/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax.debug;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLStreamException;
import junit.framework.TestCase;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.util.stax.debug.XMLStreamReaderValidator;

public class XMLStreamReaderValidatorTest
extends TestCase {
    private static XMLStreamReaderValidator createValidatorForParser(String xml) throws XMLStreamException {
        return new XMLStreamReaderValidator(StAXUtils.createXMLStreamReader((Reader)new StringReader(xml)), true);
    }

    public void testGetElementText() throws Exception {
        XMLStreamReaderValidator validator = XMLStreamReaderValidatorTest.createValidatorForParser("<root><a>text</a></root>");
        XMLStreamReaderValidatorTest.assertEquals((int)1, (int)validator.next());
        XMLStreamReaderValidatorTest.assertEquals((int)1, (int)validator.next());
        XMLStreamReaderValidatorTest.assertEquals((String)"text", (String)validator.getElementText());
        XMLStreamReaderValidatorTest.assertEquals((int)2, (int)validator.getEventType());
        XMLStreamReaderValidatorTest.assertEquals((int)2, (int)validator.next());
        XMLStreamReaderValidatorTest.assertEquals((int)8, (int)validator.next());
    }

    public void testNextTag() throws Exception {
        XMLStreamReaderValidator validator = XMLStreamReaderValidatorTest.createValidatorForParser("<root>\n  <a/>\n</root>");
        XMLStreamReaderValidatorTest.assertEquals((int)1, (int)validator.nextTag());
        XMLStreamReaderValidatorTest.assertEquals((int)1, (int)validator.nextTag());
        XMLStreamReaderValidatorTest.assertEquals((int)2, (int)validator.next());
        XMLStreamReaderValidatorTest.assertEquals((int)2, (int)validator.nextTag());
        XMLStreamReaderValidatorTest.assertEquals((int)8, (int)validator.next());
    }
}

