/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax.xop;

import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import junit.framework.Assert;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.TestConstants;
import org.apache.axiom.om.impl.builder.OMAttachmentAccessorMimePartProvider;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.testutils.stax.XMLStreamReaderComparator;
import org.apache.axiom.util.stax.xop.ContentIDGenerator;
import org.apache.axiom.util.stax.xop.MimePartProvider;
import org.apache.axiom.util.stax.xop.OptimizationPolicy;
import org.apache.axiom.util.stax.xop.XOPDecodingStreamReader;
import org.apache.axiom.util.stax.xop.XOPEncodingStreamReader;

public class XOPEncodingStreamReaderTest
extends AbstractTestCase {
    private static ContentIDGenerator contentIDGenerator = new ContentIDGenerator(){

        public String generateContentID(String existingContentID) {
            if (existingContentID == null) {
                Assert.fail();
            }
            return existingContentID;
        }
    };

    public void test() throws Exception {
        Attachments[] attachments = new Attachments[2];
        XMLStreamReader[] soapPartReader = new XMLStreamReader[2];
        for (int i = 0; i < 2; ++i) {
            attachments[i] = new Attachments(XOPEncodingStreamReaderTest.getTestResource(TestConstants.MTOM_MESSAGE.getName()), TestConstants.MTOM_MESSAGE.getContentType());
            soapPartReader[i] = StAXUtils.createXMLStreamReader((InputStream)attachments[i].getRootPartInputStream());
        }
        XOPEncodingStreamReader actual = new XOPEncodingStreamReader((XMLStreamReader)new XOPDecodingStreamReader(soapPartReader[1], (MimePartProvider)new OMAttachmentAccessorMimePartProvider((OMAttachmentAccessor)attachments[1])), contentIDGenerator, OptimizationPolicy.DEFAULT);
        new XMLStreamReaderComparator(soapPartReader[0], (XMLStreamReader)actual).compare();
        for (int i = 0; i < 2; ++i) {
            soapPartReader[i].close();
        }
    }
}

