/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.IncomingAttachmentInputStream;
import org.apache.axiom.attachments.IncomingAttachmentStreams;
import org.apache.axiom.attachments.MyLifecycleManager;
import org.apache.axiom.attachments.lifecycle.DataHandlerExt;
import org.apache.axiom.attachments.lifecycle.LifecycleManager;
import org.apache.axiom.ext.activation.SizeAwareDataSource;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.MIMEResource;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.TestConstants;
import org.apache.axiom.testutils.activation.RandomDataSource;
import org.apache.axiom.testutils.io.ExceptionInputStream;
import org.apache.axiom.testutils.io.IOTestUtils;
import org.apache.axiom.util.UIDGenerator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;

public class AttachmentsTest
extends AbstractTestCase {
    private static String getAttachmentsDir() {
        File attachmentsDir = new File(System.getProperty("basedir", ".") + "/target/attachments");
        attachmentsDir.mkdirs();
        return attachmentsDir.getAbsolutePath();
    }

    public void testGetDataHandler() throws Exception {
        InputStream inStream = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        Attachments attachments = new Attachments(inStream, TestConstants.MTOM_MESSAGE.getContentType());
        DataHandler dh = attachments.getDataHandler("2.urn:uuid:A3ADBAEE51A1A87B2A11443668160994@apache.org");
        InputStream dataIs = dh.getDataSource().getInputStream();
        InputStream expectedDataIs = AttachmentsTest.getTestResource("mtom/img/test2.jpg");
        IOTestUtils.compareStreams((InputStream)dataIs, (InputStream)expectedDataIs);
    }

    public void testGetDataHandlerNonExistingMIMEPart() throws Exception {
        InputStream inStream = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        Attachments attachments = new Attachments(inStream, TestConstants.MTOM_MESSAGE.getContentType());
        DataHandler dh = attachments.getDataHandler("ThisShouldReturnNull");
        AttachmentsTest.assertNull((Object)dh);
    }

    public void testGetDataHandlerNonExistingMIMEPartWithoutStream() throws Exception {
        Attachments attachments = new Attachments();
        attachments.addDataHandler("id@apache.org", new DataHandler((Object)"test", "text/plain"));
        AttachmentsTest.assertNull((Object)attachments.getDataHandler("non-existing@apache.org"));
    }

    public void testGetAllContentIDs() throws Exception {
        InputStream inStream = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        Attachments attachments = new Attachments(inStream, TestConstants.MTOM_MESSAGE.getContentType());
        String[] contentIDs = attachments.getAllContentIDs();
        AttachmentsTest.assertEquals((int)3, (int)contentIDs.length);
        AttachmentsTest.assertEquals((String)"0.urn:uuid:A3ADBAEE51A1A87B2A11443668160702@apache.org", (String)contentIDs[0]);
        AttachmentsTest.assertEquals((String)"1.urn:uuid:A3ADBAEE51A1A87B2A11443668160943@apache.org", (String)contentIDs[1]);
        AttachmentsTest.assertEquals((String)"2.urn:uuid:A3ADBAEE51A1A87B2A11443668160994@apache.org", (String)contentIDs[2]);
    }

    public void testGetAllContentIDsWithoutStream() {
        Attachments attachments = new Attachments();
        attachments.addDataHandler("contentB@apache.org", new DataHandler((Object)"content1", "text/plain"));
        attachments.addDataHandler("contentA@apache.org", new DataHandler((Object)"content2", "text/plain"));
        String[] contentIDs = attachments.getAllContentIDs();
        AttachmentsTest.assertEquals((int)2, (int)contentIDs.length);
        AttachmentsTest.assertEquals((String)"contentB@apache.org", (String)contentIDs[0]);
        AttachmentsTest.assertEquals((String)"contentA@apache.org", (String)contentIDs[1]);
    }

    public void testGetContentIDSet() {
        InputStream inStream = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        Attachments attachments = new Attachments(inStream, TestConstants.MTOM_MESSAGE.getContentType());
        Set idSet = attachments.getContentIDSet();
        AttachmentsTest.assertTrue((boolean)idSet.contains("0.urn:uuid:A3ADBAEE51A1A87B2A11443668160702@apache.org"));
        AttachmentsTest.assertTrue((boolean)idSet.contains("2.urn:uuid:A3ADBAEE51A1A87B2A11443668160994@apache.org"));
        AttachmentsTest.assertTrue((boolean)idSet.contains("1.urn:uuid:A3ADBAEE51A1A87B2A11443668160943@apache.org"));
    }

    public void testGetContentIDSetWithoutStream() {
        Attachments attachments = new Attachments();
        attachments.addDataHandler("id1@apache.org", new DataHandler((Object)"content1", "text/plain"));
        attachments.addDataHandler("id2@apache.org", new DataHandler((Object)"content2", "text/plain"));
        attachments.addDataHandler("id3@apache.org", new DataHandler((Object)"content3", "text/plain"));
        Set idSet = attachments.getContentIDSet();
        AttachmentsTest.assertTrue((boolean)idSet.contains("id1@apache.org"));
        AttachmentsTest.assertTrue((boolean)idSet.contains("id2@apache.org"));
        AttachmentsTest.assertTrue((boolean)idSet.contains("id3@apache.org"));
    }

    public void testGetContentLength() throws IOException {
        InputStream inStream = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        Attachments attachments = new Attachments(inStream, TestConstants.MTOM_MESSAGE.getContentType());
        long length = attachments.getContentLength();
        long fileSize = IOUtils.toByteArray((InputStream)AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName())).length;
        AttachmentsTest.assertEquals((String)"Return value of getContentLength()", (long)fileSize, (long)length);
    }

    public void testGetContentLengthWithoutStream() throws IOException {
        Attachments attachments = new Attachments();
        attachments.addDataHandler(UIDGenerator.generateContentId(), new DataHandler((Object)"test", "text/plain"));
        AttachmentsTest.assertEquals((long)-1L, (long)attachments.getContentLength());
    }

    private void testGetRootPartContentID(String contentTypeStartParam, String contentId) throws Exception {
        String contentType = "multipart/related; boundary=\"" + TestConstants.MTOM_MESSAGE.getBoundary() + "\"; type=\"text/xml\"; start=\"" + contentTypeStartParam + "\"";
        InputStream inStream = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        Attachments attachments = new Attachments(inStream, contentType);
        AttachmentsTest.assertEquals((String)"Did not obtain correct content ID", (String)contentId, (String)attachments.getRootPartContentID());
    }

    public void testGetRootPartContentIDWithoutBrackets() throws Exception {
        this.testGetRootPartContentID("my-content-id@localhost", "my-content-id@localhost");
    }

    public void testGetRootPartContentIDWithBrackets() throws Exception {
        this.testGetRootPartContentID("<my-content-id@localhost>", "my-content-id@localhost");
    }

    public void testGetRootPartContentIDWithCidPrefix() throws Exception {
        this.testGetRootPartContentID("cid:my-content-id@localhost", "my-content-id@localhost");
    }

    public void testGetRootPartContentIDWithCidPrefix2() throws Exception {
        this.testGetRootPartContentID("<cid-73920@192.168.0.1>", "cid-73920@192.168.0.1");
    }

    public void testGetRootPartContentIDShort() throws Exception {
        this.testGetRootPartContentID("bbb", "bbb");
    }

    public void testGetRootPartContentIDShortWithBrackets() throws Exception {
        this.testGetRootPartContentID("<b>", "b");
    }

    public void testGetRootPartContentIDBorderline() throws Exception {
        this.testGetRootPartContentID("cid:", "cid:");
    }

    public void testGetRootPartContentTypeWithContentIDMismatch() {
        String contentType = "multipart/related; boundary=\"" + TestConstants.MTOM_MESSAGE.getBoundary() + "\"; type=\"text/xml\"; start=\"<wrong-content-id@example.org>\"";
        Attachments attachments = new Attachments(AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName()), contentType);
        try {
            attachments.getRootPartContentType();
            AttachmentsTest.fail((String)"Expected OMException");
        }
        catch (OMException ex) {
        }
        catch (Throwable ex) {
            AttachmentsTest.fail((String)("Unexpected exception: " + ex.getClass().getName()));
        }
    }

    public void testGetIncomingAttachmentStreams() throws Exception {
        InputStream inStream = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        Attachments attachments = new Attachments(inStream, TestConstants.MTOM_MESSAGE.getContentType());
        IncomingAttachmentStreams ias = attachments.getIncomingAttachmentStreams();
        IncomingAttachmentInputStream dataIs = ias.getNextStream();
        AttachmentsTest.assertEquals((String)"<1.urn:uuid:A3ADBAEE51A1A87B2A11443668160943@apache.org>", (String)dataIs.getContentId());
        while (dataIs.read() != -1) {
        }
        dataIs = ias.getNextStream();
        AttachmentsTest.assertEquals((String)"<2.urn:uuid:A3ADBAEE51A1A87B2A11443668160994@apache.org>", (String)dataIs.getContentId());
        AttachmentsTest.assertEquals((String)"image/jpeg", (String)dataIs.getContentType());
        dataIs.addHeader("new-header", "test-value");
        AttachmentsTest.assertEquals((String)"test-value", (String)dataIs.getHeader("new-header"));
    }

    public void testGetIncomingAttachmentStreams2() throws Exception {
        InputStream inStream = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        Attachments attachments = new Attachments(inStream, TestConstants.MTOM_MESSAGE.getContentType());
        InputStream is = attachments.getRootPartInputStream();
        while (is.read() != -1) {
        }
        IncomingAttachmentStreams ias = attachments.getIncomingAttachmentStreams();
        IncomingAttachmentInputStream dataIs = ias.getNextStream();
        InputStream expectedDataIs = AttachmentsTest.getTestResource("mtom/img/test.jpg");
        IOTestUtils.compareStreams((InputStream)dataIs, (InputStream)expectedDataIs);
        dataIs = ias.getNextStream();
        expectedDataIs = AttachmentsTest.getTestResource("mtom/img/test2.jpg");
        IOTestUtils.compareStreams((InputStream)dataIs, (InputStream)expectedDataIs);
        AttachmentsTest.assertNull((Object)ias.getNextStream());
        is = attachments.getRootPartInputStream();
        while (is.read() != -1) {
        }
    }

    public void testSimultaneousStreamAccess() throws Exception {
        InputStream inStream = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        Attachments attachments = new Attachments(inStream, TestConstants.MTOM_MESSAGE.getContentType());
        attachments.getDataHandler("2.urn:uuid:A3ADBAEE51A1A87B2A11443668160994@apache.org");
        try {
            attachments.getIncomingAttachmentStreams();
            AttachmentsTest.fail((String)"No exception caught when attempting to access datahandler and stream at the same time");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        inStream.close();
        inStream = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        attachments = new Attachments(inStream, TestConstants.MTOM_MESSAGE.getContentType());
        attachments.getIncomingAttachmentStreams();
        try {
            String contentType = attachments.getRootPartContentType();
            AttachmentsTest.assertTrue((contentType.indexOf("application/xop+xml;") >= 0 ? 1 : 0) != 0);
            AttachmentsTest.assertTrue((contentType.indexOf("charset=UTF-8;") >= 0 ? 1 : 0) != 0);
            AttachmentsTest.assertTrue((contentType.indexOf("type=\"application/soap+xml\";") >= 0 ? 1 : 0) != 0);
        }
        catch (IllegalStateException ise) {
            AttachmentsTest.fail((String)"No exception expected when requesting SOAP part data");
            ise.printStackTrace();
        }
        try {
            attachments.getRootPartInputStream();
        }
        catch (IllegalStateException ise) {
            AttachmentsTest.fail((String)"No exception expected when requesting SOAP part data");
        }
        try {
            attachments.getDataHandler("2.urn:uuid:A3ADBAEE51A1A87B2A11443668160994@apache.org");
            AttachmentsTest.fail((String)"No exception caught when attempting to access stream and datahandler at the same time");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            attachments.getAllContentIDs();
            AttachmentsTest.fail((String)"No exception caught when attempting to access stream and contentids list at the same time");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            attachments.getDataHandler("2.urn:uuid:A3ADBAEE51A1A87B2A11443668160994@apache.org");
            AttachmentsTest.fail((String)"No exception caught when attempting to access stream and part at the same time");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testRemoveDataHandlerAfterParsing() {
        InputStream inStream = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        Attachments attachments = new Attachments(inStream, TestConstants.MTOM_MESSAGE.getContentType());
        Set list = attachments.getContentIDSet();
        AttachmentsTest.assertEquals((int)3, (int)list.size());
        AttachmentsTest.assertTrue((boolean)list.contains("1.urn:uuid:A3ADBAEE51A1A87B2A11443668160943@apache.org"));
        AttachmentsTest.assertTrue((boolean)list.contains("2.urn:uuid:A3ADBAEE51A1A87B2A11443668160994@apache.org"));
        attachments.removeDataHandler("1.urn:uuid:A3ADBAEE51A1A87B2A11443668160943@apache.org");
        List list2 = attachments.getContentIDList();
        AttachmentsTest.assertEquals((int)2, (int)list2.size());
        AttachmentsTest.assertEquals((int)2, (int)attachments.getMap().size());
        AttachmentsTest.assertFalse((boolean)list2.contains("1.urn:uuid:A3ADBAEE51A1A87B2A11443668160943@apache.org"));
        AttachmentsTest.assertTrue((boolean)list2.contains("2.urn:uuid:A3ADBAEE51A1A87B2A11443668160994@apache.org"));
    }

    public void testRemoveDataHandlerBeforeParsing() {
        InputStream inStream = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        Attachments attachments = new Attachments(inStream, TestConstants.MTOM_MESSAGE.getContentType());
        attachments.removeDataHandler("1.urn:uuid:A3ADBAEE51A1A87B2A11443668160943@apache.org");
        Set idSet = attachments.getContentIDSet();
        AttachmentsTest.assertEquals((int)2, (int)idSet.size());
        AttachmentsTest.assertTrue((boolean)idSet.contains("0.urn:uuid:A3ADBAEE51A1A87B2A11443668160702@apache.org"));
        AttachmentsTest.assertFalse((boolean)idSet.contains("1.urn:uuid:A3ADBAEE51A1A87B2A11443668160943@apache.org"));
        AttachmentsTest.assertTrue((boolean)idSet.contains("2.urn:uuid:A3ADBAEE51A1A87B2A11443668160994@apache.org"));
    }

    public void testRemoveDataHandlerNonExistingWithStream() {
        InputStream inStream = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        Attachments attachments = new Attachments(inStream, TestConstants.MTOM_MESSAGE.getContentType());
        attachments.removeDataHandler("non-existing@apache.org");
        AttachmentsTest.assertEquals((int)3, (int)attachments.getContentIDSet().size());
    }

    public void testRemoveDataHandlerNonExistingWithoutStream() {
        Attachments attachments = new Attachments();
        attachments.addDataHandler("id@apache.org", new DataHandler((Object)"test", "text/plain"));
        attachments.removeDataHandler("non-existing@apache.org");
        AttachmentsTest.assertEquals((int)1, (int)attachments.getContentIDSet().size());
    }

    private void testReadBase64EncodedAttachment(boolean useFile) throws Exception {
        MimeMessage message = new MimeMessage((Session)null);
        MimeMultipart mp = new MimeMultipart("related");
        MimeBodyPart bp1 = new MimeBodyPart();
        bp1.setText("<root/>", "utf-8", "xml");
        bp1.addHeader("Content-Transfer-Encoding", "binary");
        bp1.addHeader("Content-ID", "part1@apache.org");
        mp.addBodyPart((BodyPart)bp1);
        MimeBodyPart bp2 = new MimeBodyPart();
        byte[] content = new byte[8192];
        new Random().nextBytes(content);
        bp2.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(content, "application/octet-stream")));
        bp2.addHeader("Content-Transfer-Encoding", "base64");
        bp2.addHeader("Content-ID", "part2@apache.org");
        mp.addBodyPart((BodyPart)bp2);
        message.setContent((Multipart)mp);
        message.saveChanges();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        mp.writeTo((OutputStream)baos);
        String contentType = message.getContentType();
        ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
        Attachments attachments = useFile ? new Attachments((InputStream)in, contentType, true, AttachmentsTest.getAttachmentsDir(), "1024") : new Attachments((InputStream)in, contentType);
        DataHandler dh = attachments.getDataHandler("part2@apache.org");
        byte[] content2 = IOUtils.toByteArray((InputStream)dh.getInputStream());
        AttachmentsTest.assertTrue((boolean)Arrays.equals(content, content2));
    }

    public void testReadBase64EncodedAttachmentWithPartOnMemory() throws Exception {
        this.testReadBase64EncodedAttachment(false);
    }

    public void testReadBase64EncodedAttachmentWithPartOnFile() throws Exception {
        this.testReadBase64EncodedAttachment(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testZeroLengthAttachment() throws Exception {
        InputStream in = AttachmentsTest.getTestResource("mtom/zero-length-attachment.bin");
        try {
            Attachments attachments = new Attachments(in, "multipart/related; boundary=MIMEBoundaryurn_uuid_0549F3F826EC3041861188639371825; type=\"application/xop+xml\"; start=\"0.urn:uuid:0549F3F826EC3041861188639371826@apache.org\"; start-info=\"application/soap+xml\"; action=\"urn:test\"");
            DataHandler dh = attachments.getDataHandler("1.urn:uuid:0549F3F826EC3041861188639371827@apache.org");
            InputStream content = dh.getInputStream();
            AttachmentsTest.assertEquals((int)-1, (int)content.read());
        }
        finally {
            in.close();
        }
    }

    public void testPurgeDataSource() throws Exception {
        InputStream in = AttachmentsTest.getTestResource("mtom/msg-soap-wls81.txt");
        MyLifecycleManager manager = new MyLifecycleManager();
        Attachments attachments = new Attachments((LifecycleManager)manager, in, "multipart/related;type=\"text/xml\";boundary=\"----=_Part_0_3437046.1188904239130\";start=__WLS__1188904239161__SOAP__", true, AttachmentsTest.getAttachmentsDir(), "1024");
        DataHandler dh = attachments.getDataHandler("__WLS__1188904239162__SOAP__");
        AttachmentsTest.assertTrue((boolean)(dh instanceof DataHandlerExt));
        InputStream content = dh.getInputStream();
        IOUtils.copy((InputStream)content, (OutputStream)new NullOutputStream());
        content.close();
        AttachmentsTest.assertEquals((int)1, (int)manager.getFileCount());
        ((DataHandlerExt)dh).purgeDataSource();
        AttachmentsTest.assertEquals((int)0, (int)manager.getFileCount());
        in.close();
    }

    public void testReadOnceOnBufferedPart() throws Exception {
        InputStream in = AttachmentsTest.getTestResource("mtom/msg-soap-wls81.txt");
        MyLifecycleManager manager = new MyLifecycleManager();
        Attachments attachments = new Attachments((LifecycleManager)manager, in, "multipart/related;type=\"text/xml\";boundary=\"----=_Part_0_3437046.1188904239130\";start=__WLS__1188904239161__SOAP__", true, AttachmentsTest.getAttachmentsDir(), "1024");
        DataHandler dh = attachments.getDataHandler("__WLS__1188904239162__SOAP__");
        InputStream content = dh.getInputStream();
        IOUtils.copy((InputStream)content, (OutputStream)new NullOutputStream());
        content.close();
        AttachmentsTest.assertEquals((int)1, (int)manager.getFileCount());
        content = ((DataHandlerExt)dh).readOnce();
        IOUtils.copy((InputStream)content, (OutputStream)new NullOutputStream());
        content.close();
        AttachmentsTest.assertEquals((int)0, (int)manager.getFileCount());
        in.close();
    }

    public void testFileBufferingWithLowThreshold() throws Exception {
        InputStream in = AttachmentsTest.getTestResource("mtom/msg-soap-wls81.txt");
        Attachments attachments = new Attachments(in, "multipart/related;type=\"text/xml\";boundary=\"----=_Part_0_3437046.1188904239130\";start=__WLS__1188904239161__SOAP__", true, AttachmentsTest.getAttachmentsDir(), "1");
        DataHandler dh = attachments.getDataHandler("__WLS__1188904239162__SOAP__");
        BufferedReader reader = new BufferedReader(new InputStreamReader(dh.getInputStream(), "UTF-8"));
        AttachmentsTest.assertEquals((String)"%PDF-1.3", (String)reader.readLine());
        reader.close();
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDataHandlerStreaming() throws Exception {
        MimeMessage message = new MimeMessage((Session)null);
        final MimeMultipart mp = new MimeMultipart("related");
        MimeBodyPart bp1 = new MimeBodyPart();
        bp1.setText("<root/>", "utf-8", "xml");
        bp1.addHeader("Content-Transfer-Encoding", "binary");
        bp1.addHeader("Content-ID", "part1@apache.org");
        mp.addBodyPart((BodyPart)bp1);
        RandomDataSource dataSource = new RandomDataSource((long)((int)Math.min(Runtime.getRuntime().maxMemory(), Integer.MAX_VALUE)));
        MimeBodyPart bp2 = new MimeBodyPart();
        bp2.setDataHandler(new DataHandler((DataSource)dataSource));
        bp2.addHeader("Content-Transfer-Encoding", "binary");
        bp2.addHeader("Content-ID", "part2@apache.org");
        mp.addBodyPart((BodyPart)bp2);
        message.setContent((Multipart)mp);
        message.saveChanges();
        final PipedOutputStream pipeOut = new PipedOutputStream();
        PipedInputStream pipeIn = new PipedInputStream(pipeOut);
        Thread producerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        mp.writeTo((OutputStream)pipeOut);
                    }
                    finally {
                        pipeOut.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        producerThread.start();
        try {
            Attachments attachments = new Attachments((InputStream)pipeIn, message.getContentType());
            DataHandlerExt dh = (DataHandlerExt)attachments.getDataHandler("part2@apache.org");
            IOTestUtils.compareStreams((InputStream)dataSource.getInputStream(), (InputStream)dh.readOnce());
        }
        finally {
            pipeIn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTurkishLocale(String contentIDHeaderName) throws Exception {
        Locale locale = Locale.getDefault();
        Locale.setDefault(new Locale("tr", "TR"));
        try {
            MimeMessage message = new MimeMessage((Session)null);
            MimeMultipart mp = new MimeMultipart("related");
            MimeBodyPart bp1 = new MimeBodyPart();
            bp1.setText("<root/>", "utf-8", "xml");
            bp1.addHeader("Content-Transfer-Encoding", "binary");
            mp.addBodyPart((BodyPart)bp1);
            MimeBodyPart bp2 = new MimeBodyPart();
            byte[] content = new byte[8192];
            new Random().nextBytes(content);
            bp2.setDataHandler(new DataHandler((Object)"Test", "text/plain"));
            bp2.addHeader("Content-Transfer-Encoding", "binary");
            bp2.addHeader(contentIDHeaderName, "part@apache.org");
            mp.addBodyPart((BodyPart)bp2);
            message.setContent((Multipart)mp);
            message.saveChanges();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            mp.writeTo((OutputStream)baos);
            String contentType = message.getContentType();
            ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
            Attachments attachments = new Attachments((InputStream)in, contentType);
            AttachmentsTest.assertNotNull((Object)attachments.getDataHandler("part@apache.org"));
        }
        finally {
            Locale.setDefault(locale);
        }
    }

    public void testTurkishLocale1() throws Exception {
        this.testTurkishLocale("Content-ID");
    }

    public void testTurkishLocale2() throws Exception {
        this.testTurkishLocale("content-id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetAttachmentSpecType(MIMEResource resource, String expectedResult) throws Exception {
        InputStream in = AttachmentsTest.getTestResource(resource.getName());
        try {
            Attachments attachments = new Attachments(in, resource.getContentType());
            AttachmentsTest.assertEquals((String)expectedResult, (String)attachments.getAttachmentSpecType());
        }
        finally {
            in.close();
        }
    }

    public void testGetAttachmentSpecTypeMTOM() throws Exception {
        this.testGetAttachmentSpecType(TestConstants.MTOM_MESSAGE, "application/xop+xml");
    }

    public void testGetAttachmentSpecTypeSWA() throws Exception {
        this.testGetAttachmentSpecType(TestConstants.SWA_MESSAGE, "text/xml");
    }

    public void testGetAttachmentSpecTypeWithoutStream() {
        try {
            new Attachments().getAttachmentSpecType();
            AttachmentsTest.fail((String)"Expected OMException");
        }
        catch (OMException oMException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetSizeOnDataSource(boolean useFiles) throws Exception {
        InputStream in = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        try {
            Attachments attachments = useFiles ? new Attachments(in, TestConstants.MTOM_MESSAGE.getContentType(), true, AttachmentsTest.getAttachmentsDir(), "4096") : new Attachments(in, TestConstants.MTOM_MESSAGE.getContentType());
            DataHandler dh = attachments.getDataHandler("2.urn:uuid:A3ADBAEE51A1A87B2A11443668160994@apache.org");
            DataSource ds = dh.getDataSource();
            AttachmentsTest.assertTrue((boolean)(ds instanceof SizeAwareDataSource));
            AttachmentsTest.assertEquals((long)13887L, (long)((SizeAwareDataSource)ds).getSize());
        }
        finally {
            in.close();
        }
    }

    public void testGetSizeOnDataSourceOnMemory() throws Exception {
        this.testGetSizeOnDataSource(false);
    }

    public void testGetSizeOnDataSourceOnFile() throws Exception {
        this.testGetSizeOnDataSource(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIOExceptionInPartHeaders() throws Exception {
        InputStream in = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        try {
            Attachments attachments = new Attachments((InputStream)new ExceptionInputStream(in, 1050), TestConstants.MTOM_MESSAGE.getContentType());
            try {
                attachments.getDataHandler("1.urn:uuid:A3ADBAEE51A1A87B2A11443668160943@apache.org");
                AttachmentsTest.fail((String)"Expected exception");
            }
            catch (OMException oMException) {
                // empty catch block
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIOExceptionInPartContent() throws Exception {
        InputStream in = AttachmentsTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        try {
            Attachments attachments = new Attachments((InputStream)new ExceptionInputStream(in, 1500), TestConstants.MTOM_MESSAGE.getContentType());
            DataHandler dh = attachments.getDataHandler("1.urn:uuid:A3ADBAEE51A1A87B2A11443668160943@apache.org");
            try {
                dh.getInputStream();
                AttachmentsTest.fail((String)"Expected exception");
            }
            catch (OMException ex) {
                // empty catch block
            }
        }
        finally {
            in.close();
        }
    }
}

