/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.IncomingAttachmentInputStream;
import org.apache.axiom.attachments.IncomingAttachmentStreams;
import org.apache.axiom.om.AbstractTestCase;

public class PdfAttachmentStreamingTest
extends AbstractTestCase {
    String contentType = "multipart/related;type=\"text/xml\";boundary=\"----=_Part_0_3437046.1188904239130\";start=__WLS__1188904239161__SOAP__";
    String inputFile = "mtom/msg-soap-wls81.txt";

    public PdfAttachmentStreamingTest(String name) {
        super(name);
    }

    public void testStreamingAttachments() throws Exception {
        InputStream inStream = PdfAttachmentStreamingTest.getTestResource(this.inputFile);
        Attachments attachments = new Attachments(inStream, this.contentType);
        IncomingAttachmentStreams attachStreams = attachments.getIncomingAttachmentStreams();
        IncomingAttachmentInputStream firstAttach = attachStreams.getNextStream();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PdfAttachmentStreamingTest.copy((InputStream)firstAttach, output);
        inStream = PdfAttachmentStreamingTest.getTestResource(this.inputFile);
        attachments = new Attachments(inStream, this.contentType);
        DataHandler h = attachments.getDataHandler(attachments.getAllContentIDs()[1]);
        ByteArrayOutputStream input = new ByteArrayOutputStream();
        PdfAttachmentStreamingTest.copy(h.getInputStream(), input);
        PdfAttachmentStreamingTest.assertEquals((String)input.toString("UTF-8"), (String)output.toString("UTF-8"));
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
    }
}

