/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.XMLStreamWriterFilter;
import org.apache.axiom.om.util.XMLStreamWriterRemoveIllegalChars;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;

public class XMLStreamWriterFilterTestCase
extends AbstractTestCase {
    private char ILLEGAL_CHAR = (char)21;
    private String ILLEGAL_ENTITY = "&#x15;";
    private char NULL_CHAR = '\u0000';
    private String NULL_ENTITY = "&#x00;";
    private final OMMetaFactory omMetaFactory;

    protected XMLStreamWriterFilterTestCase(OMMetaFactory omMetaFactory) {
        this.omMetaFactory = omMetaFactory;
    }

    public void test01() throws Exception {
        char[] chars = new char[]{this.ILLEGAL_CHAR};
        String insert = new String(chars);
        this.testInsert(insert);
    }

    public void test02() throws Exception {
        char[] chars = new char[]{this.NULL_CHAR};
        String insert = new String(chars);
        this.testInsert(insert);
    }

    public void test03() throws Exception {
        this.testInsert(this.ILLEGAL_ENTITY);
    }

    public void test04() throws Exception {
        this.testInsert(this.NULL_ENTITY);
    }

    private void testInsert(String insert) throws Exception {
        InputStream is = XMLStreamWriterFilterTestCase.getTestResource("soap/test.xml");
        SOAPEnvelope env1 = this.createEnvelope(is);
        SOAPBody body = env1.getBody();
        OMElement omElement = body.getFirstElement();
        String text = omElement.getText();
        text = text + "[" + insert + "]";
        System.out.println("New Text = " + text);
        omElement.setText(text);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OMOutputFormat omFormat = new OMOutputFormat();
        omFormat.setXmlStreamWriterFilter((XMLStreamWriterFilter)new XMLStreamWriterRemoveIllegalChars());
        env1.serialize((OutputStream)baos, omFormat);
        String xmlText = baos.toString();
        System.out.println("Serialized Text = " + xmlText);
        ByteArrayInputStream bais = new ByteArrayInputStream(xmlText.getBytes("UTF-8"));
        SOAPEnvelope env2 = this.createEnvelope(bais);
        env2.build();
    }

    protected SOAPEnvelope createEnvelope(InputStream is) throws Exception {
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(is);
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(this.omMetaFactory, parser, null);
        SOAPEnvelope sourceEnv = (SOAPEnvelope)builder.getDocumentElement();
        return sourceEnv;
    }
}

