/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.jaxp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.impl.jaxp.OMResult;
import org.apache.axiom.testutils.XMLAssertEx;
import org.apache.axiom.testutils.conformance.ConformanceTestFile;

public class StreamSourceToOMResultTestCase
extends AbstractTestCase {
    private final OMMetaFactory omMetaFactory;
    private final TransformerFactory transformerFactory;
    private final ConformanceTestFile file;

    private StreamSourceToOMResultTestCase(OMMetaFactory omMetaFactory, TransformerFactory transformerFactory, String name, ConformanceTestFile file) {
        super(name);
        this.omMetaFactory = omMetaFactory;
        this.transformerFactory = transformerFactory;
        this.file = file;
    }

    protected void runTest() throws Throwable {
        StreamSource source = new StreamSource(this.file.getUrl().toString());
        OMResult result = new OMResult(this.omMetaFactory.getOMFactory());
        this.transformerFactory.newTransformer().transform(source, (Result)result);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        result.getDocument().serialize((OutputStream)out);
        XMLAssertEx.assertXMLIdentical((URL)this.file.getUrl(), (InputStream)new ByteArrayInputStream(out.toByteArray()), (boolean)true);
    }

    public static TestSuite suite(OMMetaFactory omMetaFactory, TransformerFactory transformerFactory) throws Exception {
        TestSuite suite = new TestSuite();
        ConformanceTestFile[] files = ConformanceTestFile.getConformanceTestFiles();
        for (int i = 0; i < files.length; ++i) {
            ConformanceTestFile file = files[i];
            suite.addTest((Test)new StreamSourceToOMResultTestCase(omMetaFactory, transformerFactory, file.getShortName(), file));
        }
        return suite;
    }
}

