/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.serialize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.impl.serialize.StreamingOMSerializer;
import org.apache.axiom.testutils.XMLAssertEx;
import org.apache.axiom.testutils.conformance.ConformanceTestFile;
import org.apache.axiom.util.stax.dialect.StAXDialect;
import org.apache.axiom.util.stax.dialect.StAXDialectDetector;

public class StreamingOMSerializerTest
extends AbstractTestCase {
    private final ConformanceTestFile file;

    public StreamingOMSerializerTest(String name, ConformanceTestFile file) {
        super(name);
        this.file = file;
    }

    protected void runTest() throws Throwable {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        StAXDialect dialect = StAXDialectDetector.getDialect(inputFactory.getClass());
        inputFactory = dialect.normalize(inputFactory);
        inputFactory = dialect.enableCDataReporting(inputFactory);
        inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        XMLOutputFactory outputFactory = dialect.normalize(XMLOutputFactory.newInstance());
        StreamingOMSerializer serializer = new StreamingOMSerializer();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLStreamReader reader = inputFactory.createXMLStreamReader(new StreamSource(this.file.getUrl().toString()));
        String encoding = reader.getEncoding();
        XMLStreamWriter writer = outputFactory.createXMLStreamWriter(out, encoding);
        writer.writeStartDocument(encoding, reader.getVersion());
        serializer.serialize(reader, writer, false);
        writer.writeEndDocument();
        writer.flush();
        XMLAssertEx.assertXMLIdentical((URL)this.file.getUrl(), (InputStream)new ByteArrayInputStream(out.toByteArray()), (boolean)false);
    }

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite();
        ConformanceTestFile[] files = ConformanceTestFile.getConformanceTestFiles();
        for (int i = 0; i < files.length; ++i) {
            ConformanceTestFile file = files[i];
            suite.addTest((Test)new StreamingOMSerializerTest(file.getShortName(), file));
        }
        return suite;
    }
}

