/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import com.google.common.truth.Truth;
import java.io.File;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import junit.framework.TestCase;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.CachedFileDataSource;
import org.apache.axiom.ts.soap.MTOMSample;

public class PartOnFileTest
extends TestCase {
    File temp;

    public PartOnFileTest(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        this.createTemporaryDirectory();
    }

    public void tearDown() throws Exception {
        this.deleteTemporaryDirectory();
    }

    public void testHeaderGetSet() throws Exception {
        InputStream inStream = MTOMSample.SAMPLE1.getInputStream();
        Attachments attachments = new Attachments(inStream, MTOMSample.SAMPLE1.getContentType(), true, this.temp.getPath(), "1");
        DataHandler dh = attachments.getDataHandler("1.urn:uuid:A3ADBAEE51A1A87B2A11443668160943@apache.org");
        PartOnFileTest.assertNotNull((Object)dh);
        DataSource ds = dh.getDataSource();
        PartOnFileTest.assertNotNull((Object)ds);
        Truth.assertThat((Object)ds).isInstanceOf(CachedFileDataSource.class);
        PartOnFileTest.assertEquals((String)"image/jpeg", (String)dh.getContentType());
    }

    public void testGetAllheaders() throws Exception {
    }

    private void createTemporaryDirectory() throws Exception {
        this.temp = File.createTempFile("partOnFileTest", ".tmp");
        if (!this.temp.delete()) {
            PartOnFileTest.fail((String)("Cannot delete from temporary directory. File: " + this.temp.toURL()));
        }
        if (!this.temp.mkdir()) {
            PartOnFileTest.fail((String)"Cannot create a temporary location for part files");
        }
    }

    private void deleteTemporaryDirectory() throws Exception {
        String[] fileList = this.temp.list();
        for (int i = 0; i < fileList.length; ++i) {
            if (new File(this.temp, fileList[i]).delete()) continue;
            System.err.println("WARNING: temporary directory removal failed.");
        }
        if (!this.temp.delete()) {
            System.err.println("WARNING: temporary directory removal failed.");
        }
    }
}

