/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob.suite;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.ext.io.ReadFromSupport;
import org.apache.axiom.ext.io.StreamCopyException;

public class ByteArrayOutputStreamWithReadFromSupport
extends OutputStream
implements ReadFromSupport {
    private byte[] buffer = new byte[4096];
    private int size;
    private boolean readFromCalled;

    public void write(int b) throws IOException {
        if (this.buffer.length == this.size) {
            byte[] newBuffer = new byte[this.size * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.size);
            this.buffer = newBuffer;
        }
        this.buffer[this.size++] = (byte)b;
    }

    public long readFrom(InputStream inputStream, long length) throws StreamCopyException {
        this.readFromCalled = true;
        long read = 0L;
        while (length < 0L || read < length) {
            int b;
            try {
                b = inputStream.read();
            }
            catch (IOException ex) {
                throw new StreamCopyException(1, ex);
            }
            if (b == -1) break;
            try {
                this.write(b);
            }
            catch (IOException ex) {
                throw new StreamCopyException(2, ex);
            }
        }
        return read;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.size];
        System.arraycopy(this.buffer, 0, result, 0, this.size);
        return result;
    }

    public boolean isReadFromCalled() {
        return this.readFromCalled;
    }
}

