/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob.suite;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.axiom.blob.WritableBlob;
import org.apache.axiom.blob.suite.CleanupCallback;
import org.apache.axiom.testutils.suite.Dimension;
import org.apache.axiom.testutils.suite.MatrixTestCase;

public abstract class State
implements Dimension {
    public static final State NEW = new State("NEW"){

        public CleanupCallback transition(WritableBlob blob) throws IOException {
            return null;
        }
    };
    public static final State UNCOMMITTED = new State("UNCOMMITTED"){

        public CleanupCallback transition(WritableBlob blob) throws IOException {
            final OutputStream out = blob.getOutputStream();
            return new CleanupCallback(){

                public void cleanup() throws IOException {
                    out.close();
                }
            };
        }
    };
    public static final State COMMITTED = new State("COMMITTED"){

        public CleanupCallback transition(WritableBlob blob) throws IOException {
            blob.getOutputStream().close();
            return null;
        }
    };
    public static final State RELEASED = new State("RELEASED"){

        public CleanupCallback transition(WritableBlob blob) throws IOException {
            blob.getOutputStream().close();
            blob.release();
            return null;
        }
    };
    private final String name;

    private State(String name) {
        this.name = name;
    }

    public final void addTestParameters(MatrixTestCase testCase) {
        testCase.addTestParameter("state", this.name);
    }

    public abstract CleanupCallback transition(WritableBlob var1) throws IOException;
}

