/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob.suite;

import com.google.common.truth.Truth;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.axiom.blob.WritableBlob;
import org.apache.axiom.blob.WritableBlobFactory;
import org.apache.axiom.blob.suite.SizeSensitiveWritableBlobTestCase;
import org.apache.axiom.blob.suite.State;
import org.apache.commons.io.IOUtils;

public class TestMarkReset
extends SizeSensitiveWritableBlobTestCase {
    public TestMarkReset(WritableBlobFactory factory, int size) {
        super(factory, State.NEW, size);
    }

    protected void runTest(WritableBlob blob) throws Throwable {
        Random random = new Random();
        byte[] sourceData1 = new byte[this.size / 2];
        byte[] sourceData2 = new byte[this.size / 2];
        random.nextBytes(sourceData1);
        random.nextBytes(sourceData2);
        OutputStream out = blob.getOutputStream();
        out.write(sourceData1);
        out.write(sourceData2);
        out.close();
        InputStream in = blob.getInputStream();
        Truth.assertThat((Boolean)in.markSupported()).isTrue();
        byte[] data1 = new byte[sourceData1.length];
        byte[] data2 = new byte[sourceData2.length];
        IOUtils.readFully((InputStream)in, (byte[])data1);
        in.mark(sourceData2.length);
        IOUtils.readFully((InputStream)in, (byte[])data2);
        in.reset();
        IOUtils.readFully((InputStream)in, (byte[])data2);
        Truth.assertThat((byte[])data1).isEqualTo((Object)sourceData1);
        Truth.assertThat((byte[])data2).isEqualTo((Object)sourceData2);
    }
}

