/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob.suite;

import com.google.common.collect.Range;
import com.google.common.truth.Truth;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.axiom.blob.WritableBlob;
import org.apache.axiom.blob.WritableBlobFactory;
import org.apache.axiom.blob.suite.SizeSensitiveWritableBlobTestCase;
import org.apache.axiom.blob.suite.State;

public class TestRandomReadWrite
extends SizeSensitiveWritableBlobTestCase {
    public TestRandomReadWrite(WritableBlobFactory factory, int size) {
        super(factory, State.NEW, size);
    }

    protected void runTest(WritableBlob blob) throws Throwable {
        Random random = new Random();
        byte[] data = new byte[this.size];
        random.nextBytes(data);
        OutputStream out = blob.getOutputStream();
        int offset = 0;
        while (offset < data.length) {
            if (random.nextBoolean()) {
                out.write(data[offset++]);
                continue;
            }
            int c = Math.min(512 + random.nextInt(1024), data.length - offset);
            out.write(data, offset, c);
            offset += c;
        }
        out.close();
        Truth.assertThat((Long)blob.getSize()).isEqualTo(this.size);
        InputStream in = blob.getInputStream();
        offset = 0;
        byte[] data2 = new byte[data.length];
        byte[] buffer = new byte[2048];
        while (true) {
            int c;
            if (random.nextBoolean()) {
                int b = in.read();
                if (b == -1) break;
                Truth.assertThat((Integer)b).isIn(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(256)));
                data2[offset++] = (byte)b;
                continue;
            }
            int bufferOffset = random.nextInt(512);
            int read = in.read(buffer, bufferOffset, c = 512 + random.nextInt(1024));
            if (read == -1) break;
            int newOffset = offset + read;
            Truth.assertThat((Integer)newOffset).isAtMost((Comparable)Integer.valueOf(data2.length));
            System.arraycopy(buffer, bufferOffset, data2, offset, read);
            offset = newOffset;
        }
        Truth.assertThat((Integer)offset).isEqualTo((long)data2.length);
        in.close();
        Truth.assertThat((byte[])data2).isEqualTo((Object)data);
    }
}

