/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob.suite;

import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Random;
import org.apache.axiom.blob.WritableBlob;
import org.apache.axiom.blob.WritableBlobFactory;
import org.apache.axiom.blob.suite.SizeSensitiveWritableBlobTestCase;
import org.apache.axiom.blob.suite.State;
import org.apache.axiom.testutils.io.InstrumentedInputStream;
import org.apache.commons.io.IOUtils;

public class TestReadFrom
extends SizeSensitiveWritableBlobTestCase {
    public TestReadFrom(WritableBlobFactory factory, int size) {
        super(factory, State.NEW, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest(WritableBlob blob) throws Throwable {
        Random random = new Random();
        byte[] data = new byte[this.size];
        random.nextBytes(data);
        InstrumentedInputStream in = new InstrumentedInputStream((InputStream)new ByteArrayInputStream(data));
        Truth.assertThat((Long)blob.readFrom((InputStream)in)).isEqualTo(this.size);
        Truth.assertThat((Boolean)in.isClosed()).isFalse();
        InputStream in2 = blob.getInputStream();
        try {
            Truth.assertThat((byte[])IOUtils.toByteArray((InputStream)in2)).isEqualTo((Object)data);
        }
        finally {
            in2.close();
        }
    }
}

