/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob.suite;

import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.blob.WritableBlob;
import org.apache.axiom.blob.WritableBlobFactory;
import org.apache.axiom.blob.suite.State;
import org.apache.axiom.blob.suite.WritableBlobTestCase;
import org.apache.axiom.ext.io.ReadFromSupport;
import org.apache.commons.io.IOUtils;

public class TestReadFromSupport
extends WritableBlobTestCase {
    public TestReadFromSupport(WritableBlobFactory factory) {
        super(factory, State.NEW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest(WritableBlob blob) throws Throwable {
        OutputStream out = blob.getOutputStream();
        try {
            out.write(new byte[]{50, 60});
            ((ReadFromSupport)out).readFrom((InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3, 4}), -1L);
            ((ReadFromSupport)out).readFrom((InputStream)new ByteArrayInputStream(new byte[]{5, 6, 7, 8}), 2L);
            out.write(new byte[]{70, 80});
        }
        finally {
            out.close();
        }
        InputStream in = blob.getInputStream();
        try {
            Truth.assertThat((byte[])IOUtils.toByteArray((InputStream)in)).isEqualTo((Object)new byte[]{50, 60, 1, 2, 3, 4, 5, 6, 70, 80});
        }
        finally {
            in.close();
        }
    }
}

