/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob.suite;

import com.google.common.truth.Truth;
import java.io.OutputStream;
import java.util.Random;
import org.apache.axiom.blob.WritableBlob;
import org.apache.axiom.blob.WritableBlobFactory;
import org.apache.axiom.blob.suite.ByteArrayOutputStreamWithReadFromSupport;
import org.apache.axiom.blob.suite.SizeSensitiveWritableBlobTestCase;
import org.apache.axiom.blob.suite.State;
import org.apache.axiom.testutils.io.InstrumentedOutputStream;

public class TestWriteTo
extends SizeSensitiveWritableBlobTestCase {
    private final boolean usesReadFromSupport;

    public TestWriteTo(WritableBlobFactory factory, int size, boolean usesReadFromSupport) {
        super(factory, State.NEW, size);
        this.usesReadFromSupport = usesReadFromSupport;
    }

    protected void runTest(WritableBlob blob) throws Throwable {
        Random random = new Random();
        byte[] data = new byte[this.size];
        random.nextBytes(data);
        OutputStream out = blob.getOutputStream();
        out.write(data);
        out.close();
        ByteArrayOutputStreamWithReadFromSupport baos = new ByteArrayOutputStreamWithReadFromSupport();
        InstrumentedOutputStream closeSensor = new InstrumentedOutputStream((OutputStream)baos);
        blob.writeTo((OutputStream)baos);
        Truth.assertThat((Boolean)closeSensor.isClosed()).isFalse();
        Truth.assertThat((byte[])baos.toByteArray()).isEqualTo((Object)data);
        if (this.usesReadFromSupport) {
            Truth.assertThat((Boolean)baos.isReadFromCalled()).isTrue();
        }
    }
}

