/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob.suite;

import com.google.common.truth.Truth;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.blob.WritableBlob;
import org.apache.axiom.blob.WritableBlobFactory;
import org.apache.axiom.blob.suite.SizeSensitiveWritableBlobTestCase;
import org.apache.axiom.blob.suite.State;
import org.apache.axiom.ext.io.StreamCopyException;
import org.apache.axiom.testutils.io.ExceptionOutputStream;
import org.apache.commons.io.input.NullInputStream;

public class TestWriteToWithError
extends SizeSensitiveWritableBlobTestCase {
    public TestWriteToWithError(WritableBlobFactory factory, int size) {
        super(factory, State.NEW, size);
    }

    protected void runTest(WritableBlob blob) throws Throwable {
        blob.readFrom((InputStream)new NullInputStream((long)this.size));
        ExceptionOutputStream out = new ExceptionOutputStream(this.size / 2);
        try {
            blob.writeTo((OutputStream)out);
            TestWriteToWithError.fail((String)"Expected StreamCopyException");
        }
        catch (StreamCopyException ex) {
            Truth.assertThat((Integer)ex.getOperation()).isEqualTo(2L);
            Truth.assertThat((Throwable)ex.getCause()).isSameAs((Object)out.getException());
        }
    }
}

