/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob.suite;

import org.apache.axiom.blob.WritableBlobFactory;
import org.apache.axiom.blob.suite.State;
import org.apache.axiom.blob.suite.TestAvailable;
import org.apache.axiom.blob.suite.TestGetInputStreamIllegalState;
import org.apache.axiom.blob.suite.TestGetOutputStreamIllegalState;
import org.apache.axiom.blob.suite.TestGetSizeIllegalState;
import org.apache.axiom.blob.suite.TestMarkReset;
import org.apache.axiom.blob.suite.TestRandomReadWrite;
import org.apache.axiom.blob.suite.TestReadEOF;
import org.apache.axiom.blob.suite.TestReadFrom;
import org.apache.axiom.blob.suite.TestReadFromIllegalState;
import org.apache.axiom.blob.suite.TestReadFromSupport;
import org.apache.axiom.blob.suite.TestReadFromWithError;
import org.apache.axiom.blob.suite.TestReadZeroLength;
import org.apache.axiom.blob.suite.TestReleaseTwice;
import org.apache.axiom.blob.suite.TestSkip;
import org.apache.axiom.blob.suite.TestWriteAfterCommit;
import org.apache.axiom.blob.suite.TestWriteTo;
import org.apache.axiom.blob.suite.TestWriteToIllegalState;
import org.apache.axiom.blob.suite.TestWriteToWithError;
import org.apache.axiom.testutils.suite.MatrixTestSuiteBuilder;

public class WritableBlobTestSuiteBuilder
extends MatrixTestSuiteBuilder {
    private final WritableBlobFactory factory;
    private final int[] sizes;
    private final boolean outputStreamHasReadFromSupport;
    private final boolean writeToUsesReadFromSupport;

    public WritableBlobTestSuiteBuilder(WritableBlobFactory factory, int[] sizes, boolean outputStreamHasReadFromSupport, boolean writeToUsesReadFromSupport) {
        this.factory = factory;
        this.sizes = sizes;
        this.outputStreamHasReadFromSupport = outputStreamHasReadFromSupport;
        this.writeToUsesReadFromSupport = writeToUsesReadFromSupport;
    }

    protected void addTests() {
        this.addTest(new TestAvailable(this.factory));
        this.addTest(new TestGetInputStreamIllegalState(this.factory, State.NEW));
        this.addTest(new TestGetInputStreamIllegalState(this.factory, State.UNCOMMITTED));
        this.addTest(new TestGetInputStreamIllegalState(this.factory, State.RELEASED));
        this.addTest(new TestGetOutputStreamIllegalState(this.factory, State.UNCOMMITTED));
        this.addTest(new TestGetOutputStreamIllegalState(this.factory, State.COMMITTED));
        this.addTest(new TestGetOutputStreamIllegalState(this.factory, State.RELEASED));
        this.addTest(new TestGetSizeIllegalState(this.factory, State.NEW));
        this.addTest(new TestGetSizeIllegalState(this.factory, State.UNCOMMITTED));
        this.addTest(new TestGetSizeIllegalState(this.factory, State.RELEASED));
        this.addTest(new TestReadEOF(this.factory));
        this.addTest(new TestReadFromIllegalState(this.factory, State.UNCOMMITTED));
        this.addTest(new TestReadFromIllegalState(this.factory, State.COMMITTED));
        this.addTest(new TestReadFromIllegalState(this.factory, State.RELEASED));
        if (this.outputStreamHasReadFromSupport) {
            this.addTest(new TestReadFromSupport(this.factory));
        }
        this.addTest(new TestReadFromWithError(this.factory));
        this.addTest(new TestReadZeroLength(this.factory));
        this.addTest(new TestReleaseTwice(this.factory));
        this.addTest(new TestSkip(this.factory));
        this.addTest(new TestWriteAfterCommit(this.factory));
        this.addTest(new TestWriteToIllegalState(this.factory, State.NEW));
        this.addTest(new TestWriteToIllegalState(this.factory, State.UNCOMMITTED));
        this.addTest(new TestWriteToIllegalState(this.factory, State.RELEASED));
        for (int size : this.sizes) {
            this.addTests(size);
        }
    }

    private void addTests(int size) {
        this.addTest(new TestMarkReset(this.factory, size));
        this.addTest(new TestReadFrom(this.factory, size));
        this.addTest(new TestRandomReadWrite(this.factory, size));
        this.addTest(new TestWriteTo(this.factory, size, this.writeToUsesReadFromSupport));
        this.addTest(new TestWriteToWithError(this.factory, size));
    }
}

