/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import junit.framework.TestCase;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.mime.ContentTypeBuilder;
import org.apache.axiom.mime.MediaType;

public class ContentTypeBuilderTest
extends TestCase {
    public void testBasic() {
        ContentTypeBuilder builder = new ContentTypeBuilder(MediaType.TEXT_XML);
        builder.setParameter("charset", "utf-8");
        ContentType contentType = builder.build();
        ContentTypeBuilderTest.assertEquals((Object)MediaType.TEXT_XML, (Object)contentType.getMediaType());
        ContentTypeBuilderTest.assertEquals((String)"utf-8", (String)contentType.getParameter("charset"));
    }

    public void testFromExistingContentType() {
        ContentType contentType = new ContentType(MediaType.TEXT_XML, new String[]{"charset", "utf-8"});
        ContentTypeBuilder builder = new ContentTypeBuilder(contentType);
        ContentTypeBuilderTest.assertEquals((Object)MediaType.TEXT_XML, (Object)builder.getMediaType());
        ContentTypeBuilderTest.assertEquals((String)"utf-8", (String)builder.getParameter("charset"));
    }

    public void testParse() throws Exception {
        ContentTypeBuilder builder = new ContentTypeBuilder("text/xml; charset=utf-8");
        ContentTypeBuilderTest.assertEquals((Object)MediaType.TEXT_XML, (Object)builder.getMediaType());
        ContentTypeBuilderTest.assertEquals((String)"utf-8", (String)builder.getParameter("charset"));
    }

    public void testSetMediaType() throws Exception {
        ContentTypeBuilder builder = new ContentTypeBuilder("text/xml; charset=utf-8");
        builder.setMediaType(MediaType.APPLICATION_XML);
        ContentTypeBuilderTest.assertEquals((String)"application/xml; charset=\"utf-8\"", (String)builder.toString());
    }

    public void testGetParameterIgnoresCase() {
        ContentTypeBuilder builder = new ContentTypeBuilder(MediaType.TEXT_XML);
        builder.setParameter("charset", "utf-8");
        ContentTypeBuilderTest.assertEquals((String)"utf-8", (String)builder.getParameter("CHARSET"));
    }

    public void testSetParameterIgnoresCase() {
        ContentTypeBuilder builder = new ContentTypeBuilder(MediaType.TEXT_XML);
        builder.setParameter("charset", "utf-8");
        builder.setParameter("CHARSET", "us-ascii");
        ContentTypeBuilderTest.assertEquals((String)"us-ascii", (String)builder.getParameter("charset"));
    }

    public void testClearParameters() {
        ContentTypeBuilder builder = new ContentTypeBuilder(MediaType.TEXT_XML);
        builder.setParameter("charset", "utf-8");
        builder.clearParameters();
        ContentTypeBuilderTest.assertNull((Object)builder.getParameter("charset"));
    }
}

