/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import java.text.ParseException;
import junit.framework.TestCase;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.mime.MediaType;

public class ContentTypeTest
extends TestCase {
    public void testImmutable() {
        String[] parameters = new String[]{"charset", "utf-8"};
        ContentType ct = new ContentType(MediaType.TEXT_XML, parameters);
        parameters[1] = "ascii";
        ContentTypeTest.assertEquals((String)"utf-8", (String)ct.getParameter("charset"));
    }

    public void testGetParameterIgnoresCase() {
        ContentType ct = new ContentType(MediaType.TEXT_XML, new String[]{"charset", "utf-8"});
        ContentTypeTest.assertEquals((String)"utf-8", (String)ct.getParameter("CHARSET"));
    }

    public void testParse() throws Exception {
        ContentType ct = new ContentType("multipart/related; boundary=\"boundaryA3ADBAEE51A1A87B2A11443668160701\"; type=\"application/xop+xml\"; start=\"<A3ADBAEE51A1A87B2A11443668160702@apache.org>\"; start-info=\"application/soap+xml\"; charset=UTF-8;action=\"urn:myAction\"");
        ContentTypeTest.assertEquals((Object)MediaType.MULTIPART_RELATED, (Object)ct.getMediaType());
        ContentTypeTest.assertEquals((String)"boundaryA3ADBAEE51A1A87B2A11443668160701", (String)ct.getParameter("boundary"));
        ContentTypeTest.assertEquals((String)"application/xop+xml", (String)ct.getParameter("type"));
        ContentTypeTest.assertEquals((String)"<A3ADBAEE51A1A87B2A11443668160702@apache.org>", (String)ct.getParameter("start"));
        ContentTypeTest.assertEquals((String)"application/soap+xml", (String)ct.getParameter("start-info"));
        ContentTypeTest.assertEquals((String)"UTF-8", (String)ct.getParameter("charset"));
        ContentTypeTest.assertEquals((String)"urn:myAction", (String)ct.getParameter("action"));
    }

    public void testParseWithExtraSemicolon() throws Exception {
        ContentType ct = new ContentType("text/xml; charset=utf-8;");
        ContentTypeTest.assertEquals((Object)MediaType.TEXT_XML, (Object)ct.getMediaType());
        ContentTypeTest.assertEquals((String)"utf-8", (String)ct.getParameter("charset"));
    }

    public void testParseWithExtraSpaces() throws Exception {
        ContentType ct = new ContentType("text/xml ; charset = utf-8 ");
        ContentTypeTest.assertEquals((Object)MediaType.TEXT_XML, (Object)ct.getMediaType());
        ContentTypeTest.assertEquals((String)"utf-8", (String)ct.getParameter("charset"));
    }

    public void testParseWithQuotedPair() throws Exception {
        ContentType ct = new ContentType("application/x-some-format; comment=\"this is not a \\\"quote\\\"\"");
        ContentTypeTest.assertEquals((String)"this is not a \"quote\"", (String)ct.getParameter("comment"));
    }

    public void testParseInvalid1() {
        try {
            new ContentType("text/xml; ?");
            ContentTypeTest.fail((String)"Expected ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testParseInvalid2() {
        try {
            new ContentType("text/");
            ContentTypeTest.fail((String)"Expected ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testParseInvalid3() {
        try {
            new ContentType("text/xml; charset=");
            ContentTypeTest.fail((String)"Expected ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testParseInvalid4() {
        try {
            new ContentType("text/xml; charset=\"asc");
            ContentTypeTest.fail((String)"Expected ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testParseInvalid5() {
        try {
            new ContentType("text/xml; param=\"test\\");
            ContentTypeTest.fail((String)"Expected ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testParseInvalid6() {
        try {
            new ContentType("text/xml; param;");
            ContentTypeTest.fail((String)"Expected ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testParseInvalid7() {
        try {
            new ContentType("text/xml; param");
            ContentTypeTest.fail((String)"Expected ParseException");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testToString() {
        ContentType ct = new ContentType(MediaType.TEXT_XML, new String[]{"charset", "utf-8"});
        ContentTypeTest.assertEquals((String)"text/xml; charset=\"utf-8\"", (String)ct.toString());
    }

    public void testToStringWithQuote() {
        ContentType ct = new ContentType(new MediaType("application", "x-some-format"), new String[]{"comment", "this is not a \"quote\""});
        ContentTypeTest.assertEquals((String)"application/x-some-format; comment=\"this is not a \\\"quote\\\"\"", (String)ct.toString());
    }

    public void testToStringWithBackslash() {
        ContentType ct = new ContentType(new MediaType("application", "x-some-format"), new String[]{"filename", "c:\\temp\\test.dat"});
        ContentTypeTest.assertEquals((String)"application/x-some-format; filename=\"c:\\\\temp\\\\test.dat\"", (String)ct.toString());
    }
}

