/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import junit.framework.TestCase;
import org.apache.axiom.mime.MediaType;

public class MediaTypeTest
extends TestCase {
    public void testBasic() {
        MediaType mt = new MediaType("text", "xml");
        MediaTypeTest.assertEquals((String)"text", (String)mt.getPrimaryType());
        MediaTypeTest.assertEquals((String)"xml", (String)mt.getSubType());
    }

    public void testEquals() {
        MediaType mt1 = new MediaType("text", "xml");
        MediaType mt2 = new MediaType("text", "xml");
        MediaType mt3 = new MediaType("text", "plain");
        MediaType mt4 = new MediaType("application", "xml");
        MediaTypeTest.assertTrue((boolean)mt1.equals((Object)mt2));
        MediaTypeTest.assertFalse((boolean)mt1.equals((Object)mt3));
        MediaTypeTest.assertFalse((boolean)mt1.equals((Object)mt4));
        MediaTypeTest.assertFalse((boolean)mt3.equals((Object)mt4));
        MediaTypeTest.assertFalse((boolean)mt1.equals((Object)"test"));
    }

    public void testEqualsIgnoresCase() {
        MediaType mt1 = new MediaType("text", "xml");
        MediaType mt2 = new MediaType("TEXT", "XML");
        MediaTypeTest.assertTrue((boolean)mt1.equals((Object)mt2));
    }

    public void testHashCode() {
        MediaType mt1 = new MediaType("text", "xml");
        MediaType mt2 = new MediaType("text", "xml");
        MediaType mt3 = new MediaType("text", "plain");
        MediaType mt4 = new MediaType("application", "xml");
        MediaTypeTest.assertTrue((mt1.hashCode() == mt2.hashCode() ? 1 : 0) != 0);
        MediaTypeTest.assertFalse((mt1.hashCode() == mt3.hashCode() ? 1 : 0) != 0);
        MediaTypeTest.assertFalse((mt1.hashCode() == mt4.hashCode() ? 1 : 0) != 0);
        MediaTypeTest.assertFalse((mt3.hashCode() == mt4.hashCode() ? 1 : 0) != 0);
    }

    public void testHashCodeIgnoresCase() {
        MediaType mt1 = new MediaType("text", "xml");
        MediaType mt2 = new MediaType("TEXT", "XML");
        MediaTypeTest.assertTrue((mt1.hashCode() == mt2.hashCode() ? 1 : 0) != 0);
    }

    public void testToString() {
        MediaType mt = new MediaType("application", "octet-stream");
        MediaTypeTest.assertEquals((String)"application/octet-stream", (String)mt.toString());
    }
}

