/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.axiom.om.MethodSignature;

public class MethodCollisionTestCase
extends TestCase {
    private final Class omInterface;
    private final Class domInterface;
    private final MethodSignature[] exceptions;

    public MethodCollisionTestCase(Class omInterface, Class domInterface, MethodSignature[] exceptions) {
        this.omInterface = omInterface;
        this.domInterface = domInterface;
        this.exceptions = exceptions;
        this.setName(omInterface.getName() + " <-> " + domInterface.getName());
    }

    public MethodCollisionTestCase(Class omInterface, Class domInterface) {
        this(omInterface, domInterface, null);
    }

    private Set getMethodSignatures(Class iface) {
        HashSet<MethodSignature> result = new HashSet<MethodSignature>();
        Method[] methods = iface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            result.add(new MethodSignature(methods[i]));
        }
        return result;
    }

    protected void runTest() throws Throwable {
        Set signatures = this.getMethodSignatures(this.omInterface);
        signatures.retainAll(this.getMethodSignatures(this.domInterface));
        if (this.exceptions != null) {
            signatures.removeAll(Arrays.asList(this.exceptions));
        }
        if (!signatures.isEmpty()) {
            MethodCollisionTestCase.fail((String)("Method collision detected for the following methods: " + signatures));
        }
    }
}

