/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLStreamException;
import junit.framework.TestCase;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;

public class OMDocumentSerilizationTestBase
extends TestCase {
    private final OMMetaFactory omMetaFactory;
    private OMDocument document;
    private String xmlDeclStart = "<?xml";
    private String encoding = "encoding='UTF-8'";
    private String encoding_UTF16 = "encoding='UTF-16'";
    private String encoding2 = "encoding=\"UTF-8\"";
    private String encoding2_UTF16 = "encoding=\"UTF-16\"";
    private String version = "version='1.0'";
    private String version_11 = "version='1.1'";
    private String version2 = "version=\"1.0\"";
    private String version2_11 = "version=\"1.1\"";

    public OMDocumentSerilizationTestBase(OMMetaFactory omMetaFactory) {
        this.omMetaFactory = omMetaFactory;
    }

    public void setUp() {
        OMFactory factory = this.omMetaFactory.getOMFactory();
        OMNamespace namespace = factory.createOMNamespace("http://testuri.org", "test");
        OMElement documentElement = factory.createOMElement("DocumentElement", namespace);
        OMElement child1 = factory.createOMElement("Child1", namespace);
        child1.setText("TestText");
        documentElement.addChild((OMNode)child1);
        this.document = factory.createOMDocument();
        this.document.addChild((OMNode)documentElement);
    }

    public void testXMLDecleration() throws XMLStreamException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.document.serializeAndConsume((OutputStream)baos);
        String xmlDocument = new String(baos.toByteArray());
        OMDocumentSerilizationTestBase.assertTrue((String)"XML Declaration missing", (-1 < xmlDocument.indexOf(this.xmlDeclStart) ? 1 : 0) != 0);
    }

    public void testExcludeXMLDeclaration() throws XMLStreamException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OMOutputFormat format = new OMOutputFormat();
        format.setIgnoreXMLDeclaration(true);
        this.document.serializeAndConsume((OutputStream)baos, format);
        String xmlDocument = new String(baos.toByteArray());
        OMDocumentSerilizationTestBase.assertTrue((String)"XML Declaration is included when serilizing without the declaration", (-1 == xmlDocument.indexOf(this.xmlDeclStart) ? 1 : 0) != 0);
    }

    public void testCharsetEncoding() throws XMLStreamException {
        this.document.setCharsetEncoding("UTF-8");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.document.serializeAndConsume((OutputStream)baos);
        String xmlDocument = new String(baos.toByteArray());
        OMDocumentSerilizationTestBase.assertTrue((String)"Charset declaration missing", (-1 < xmlDocument.indexOf(this.encoding) || -1 < xmlDocument.indexOf(this.encoding.toLowerCase()) || -1 < xmlDocument.indexOf(this.encoding2.toLowerCase()) || -1 < xmlDocument.indexOf(this.encoding2) ? 1 : 0) != 0);
    }

    public void testCharsetEncodingUTF_16() throws XMLStreamException, UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OMOutputFormat format = new OMOutputFormat();
        format.setCharSetEncoding("UTF-16");
        this.document.serializeAndConsume((OutputStream)baos, format);
        String xmlDocument = new String(baos.toByteArray(), "UTF-16");
        OMDocumentSerilizationTestBase.assertTrue((String)"Charset declaration missing", (-1 < xmlDocument.indexOf(this.encoding_UTF16) || -1 < xmlDocument.indexOf(this.encoding2_UTF16) ? 1 : 0) != 0);
    }

    public void testXMLVersion() throws XMLStreamException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.document.serializeAndConsume((OutputStream)baos);
        String xmlDocument = new String(baos.toByteArray());
        OMDocumentSerilizationTestBase.assertTrue((String)"Charset declaration missing", (-1 < xmlDocument.indexOf(this.version) || -1 < xmlDocument.indexOf(this.version2) ? 1 : 0) != 0);
    }

    public void testXMLVersion_11() throws XMLStreamException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.document.setXMLVersion("1.1");
        this.document.serializeAndConsume((OutputStream)baos);
        String xmlDocument = new String(baos.toByteArray());
        OMDocumentSerilizationTestBase.assertTrue((String)"Charset declaration missing", (-1 < xmlDocument.indexOf(this.version_11) || -1 < xmlDocument.indexOf(this.version2_11) ? 1 : 0) != 0);
    }
}

