/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMXMLBuilderFactory;

public class OMDocumentTestBase
extends AbstractTestCase {
    private String sampleXML = "<?xml version='1.0' encoding='utf-8'?><!--This is some comments at the start of the document--><?PITarget PIData?><Axis2>    <ProjectName>The Apache Web Sevices Project</ProjectName></Axis2>";
    private final OMMetaFactory omMetaFactory;

    public OMDocumentTestBase(OMMetaFactory omMetaFactory) {
        this.omMetaFactory = omMetaFactory;
    }

    public void testParse() {
        OMDocument doc = this.getSampleOMDocument(this.sampleXML);
        this.checkSampleXML(doc);
        doc.close(false);
    }

    public void testSerializeAndConsume() throws XMLStreamException {
        OMDocument omDocument = this.getSampleOMDocument(this.sampleXML);
        String outXML = "";
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        omDocument.serializeAndConsume((OutputStream)outStream);
        outXML = new String(outStream.toByteArray());
        OMDocument omDocument2 = this.getSampleOMDocument(outXML);
        this.checkSampleXML(omDocument2);
        omDocument.close(false);
        omDocument2.close(false);
    }

    private void checkSampleXML(OMDocument document) {
        boolean commentFound = false;
        boolean piFound = false;
        Iterator children = document.getChildren();
        while (children.hasNext()) {
            OMNode omNode = (OMNode)children.next();
            if (omNode instanceof OMComment) {
                commentFound = true;
                continue;
            }
            if (omNode instanceof OMProcessingInstruction) {
                piFound = true;
                continue;
            }
            if (!(omNode instanceof OMElement) || commentFound || piFound) continue;
            OMDocumentTestBase.fail((String)"OMElement should come after Comment and PI");
        }
        OMDocumentTestBase.assertTrue((commentFound && piFound ? 1 : 0) != 0);
    }

    private OMDocument getSampleOMDocument(String xml) {
        return OMXMLBuilderFactory.createOMBuilder((OMFactory)this.omMetaFactory.getOMFactory(), (Reader)new StringReader(xml)).getDocument();
    }
}

