/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.serialize;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.impl.serialize.StreamingOMSerializer;
import org.apache.axiom.testing.multiton.Multiton;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.xml.XMLSample;
import org.apache.axiom.util.stax.dialect.StAXDialect;
import org.apache.axiom.util.stax.dialect.StAXDialectDetector;
import org.xml.sax.InputSource;

public class StreamingOMSerializerTest
extends AbstractTestCase {
    private final XMLSample file;

    public StreamingOMSerializerTest(String name, XMLSample file) {
        super(name);
        this.file = file;
    }

    protected void runTest() throws Throwable {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        StAXDialect dialect = StAXDialectDetector.getDialect(inputFactory.getClass());
        inputFactory = dialect.normalize(inputFactory);
        inputFactory = dialect.enableCDataReporting(inputFactory);
        inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        XMLOutputFactory outputFactory = dialect.normalize(XMLOutputFactory.newInstance());
        StreamingOMSerializer serializer = new StreamingOMSerializer();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLStreamReader reader = inputFactory.createXMLStreamReader(new StreamSource(this.file.getUrl().toString()));
        String encoding = reader.getEncoding();
        XMLStreamWriter writer = outputFactory.createXMLStreamWriter(out, encoding);
        writer.writeStartDocument(encoding, reader.getVersion());
        serializer.serialize(reader, writer, false);
        writer.writeEndDocument();
        writer.flush();
        InputSource actual = new InputSource();
        actual.setByteStream(new ByteArrayInputStream(out.toByteArray()));
        actual.setSystemId(this.file.getUrl().toString());
        ((XMLSubject)Truth.assertAbout((SubjectFactory)XMLTruth.xml()).that((Object)actual)).hasSameContentAs((Object)this.file.getUrl());
    }

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite();
        for (XMLSample file : Multiton.getInstances(XMLSample.class)) {
            suite.addTest((Test)new StreamingOMSerializerTest(file.getName(), file));
        }
        return suite;
    }
}

