/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.axiom.util.UIDGenerator;

public class UIDGeneratorTest
extends TestCase {
    public void testGenerateContentIdFormat() {
        UIDGeneratorTest.assertTrue((boolean)Pattern.matches("\\w+(\\.\\w+)*@\\w+(\\.\\w+)", UIDGenerator.generateContentId()));
    }

    public void testGenerateContentIdUniqueness() {
        HashSet<String> values = new HashSet<String>();
        for (int i = 0; i < 1000; ++i) {
            UIDGeneratorTest.assertTrue((boolean)values.add(UIDGenerator.generateContentId()));
        }
    }

    public void testGenerateMimeBoundaryLength() {
        UIDGeneratorTest.assertTrue((UIDGenerator.generateMimeBoundary().length() <= 70 ? 1 : 0) != 0);
    }

    public void testGenerateUIDThreadSafety() {
        int i;
        final Set generatedIds = Collections.synchronizedSet(new HashSet());
        final AtomicInteger errorCount = new AtomicInteger(0);
        Thread[] threads = new Thread[100];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new Runnable(){

                public void run() {
                    for (int i = 0; i < 1000; ++i) {
                        String id = UIDGenerator.generateUID();
                        if (generatedIds.add(id)) continue;
                        System.out.println("ERROR - Same UID has been generated before. UID: " + id);
                        errorCount.incrementAndGet();
                    }
                }
            });
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        UIDGeneratorTest.assertEquals((int)0, (int)errorCount.get());
    }

    public void testGenerateURNString() {
        int i;
        Thread[] threads = new Thread[100];
        String[][] urns = new String[threads.length][1000];
        for (i = 0; i < threads.length; ++i) {
            final String[] threadURNs = urns[i];
            threads[i] = new Thread(new Runnable(){

                public void run() {
                    for (int i = 0; i < threadURNs.length; ++i) {
                        threadURNs[i] = UIDGenerator.generateURNString();
                    }
                }
            });
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        HashSet<String> set = new HashSet<String>();
        for (int i2 = 0; i2 < threads.length; ++i2) {
            for (int j = 0; j < urns[i2].length; ++j) {
                String urn = urns[i2][j];
                UIDGeneratorTest.assertTrue((boolean)urn.startsWith("urn:uuid:"));
                UIDGeneratorTest.assertTrue((boolean)set.add(urn));
                UUID uuid = UUID.fromString(urn.substring(9));
                UIDGeneratorTest.assertEquals((int)4, (int)uuid.version());
                UIDGeneratorTest.assertEquals((int)2, (int)uuid.variant());
            }
        }
    }
}

