/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.base64;

import com.google.common.truth.Truth;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.commons.codec.binary.Base64;

public class Base64UtilsTest
extends TestCase {
    public void testDecode() {
        Random random = new Random(43219876L);
        for (int len = 0; len < 20; ++len) {
            byte[] data = new byte[len];
            random.nextBytes(data);
            Truth.assertThat((byte[])Base64Utils.decode((String)Base64.encodeBase64String((byte[])data))).isEqualTo((Object)data);
        }
    }

    public void testMissingPadding() {
        try {
            Base64Utils.decode((String)"cw");
            Base64UtilsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTooMuchPadding() {
        try {
            Base64Utils.decode((String)"cw===");
            Base64UtilsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNonZeroRemainder() {
        try {
            Base64Utils.decode((String)"//==");
            Base64UtilsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSpace() throws Exception {
        Base64UtilsTest.assertEquals((String)"any carnal pleasure.", (String)new String(Base64Utils.decode((String)" YW55IG\tNhcm5hbC\r\nBwb  GVhc3VyZS4 = "), "utf-8"));
    }

    public void testInvalidCharacter() {
        try {
            Base64Utils.decode((String)"//-/");
            Base64UtilsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInvalidPadding() {
        try {
            Base64Utils.decode((String)"//=/");
            Base64UtilsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

