/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.namespace;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import junit.framework.TestCase;
import org.apache.axiom.testutils.namespace.NamespaceContextTestUtils;
import org.apache.axiom.util.namespace.ScopedNamespaceContext;

public class ScopedNamespaceContextTest
extends TestCase {
    private static Set getPrefixes(NamespaceContext nc, String namespaceURI) {
        HashSet<String> result = new HashSet<String>();
        Iterator<String> it = nc.getPrefixes(namespaceURI);
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public void testSimple() {
        ScopedNamespaceContext nc = new ScopedNamespaceContext();
        nc.setPrefix("", "urn:ns1");
        nc.setPrefix("a", "urn:ns2");
        nc.setPrefix("b", "urn:ns3");
        ScopedNamespaceContextTest.assertEquals((String)"urn:ns1", (String)nc.getNamespaceURI(""));
        ScopedNamespaceContextTest.assertEquals((String)"urn:ns2", (String)nc.getNamespaceURI("a"));
        ScopedNamespaceContextTest.assertEquals((String)"urn:ns3", (String)nc.getNamespaceURI("b"));
        ScopedNamespaceContextTest.assertEquals((String)"", (String)nc.getPrefix("urn:ns1"));
        ScopedNamespaceContextTest.assertEquals((String)"a", (String)nc.getPrefix("urn:ns2"));
        ScopedNamespaceContextTest.assertEquals((String)"b", (String)nc.getPrefix("urn:ns3"));
        ScopedNamespaceContextTest.assertEquals(Collections.singleton(""), (Object)ScopedNamespaceContextTest.getPrefixes((NamespaceContext)nc, "urn:ns1"));
        ScopedNamespaceContextTest.assertEquals(Collections.singleton("a"), (Object)ScopedNamespaceContextTest.getPrefixes((NamespaceContext)nc, "urn:ns2"));
        ScopedNamespaceContextTest.assertEquals(Collections.singleton("b"), (Object)ScopedNamespaceContextTest.getPrefixes((NamespaceContext)nc, "urn:ns3"));
    }

    public void testMultiplePrefixes() {
        ScopedNamespaceContext nc = new ScopedNamespaceContext();
        nc.setPrefix("", "urn:ns1");
        nc.setPrefix("a", "urn:ns2");
        nc.setPrefix("b", "urn:ns1");
        String prefix = nc.getPrefix("urn:ns1");
        ScopedNamespaceContextTest.assertTrue((prefix.equals("") || prefix.equals("b") ? 1 : 0) != 0);
        ScopedNamespaceContextTest.assertEquals(new HashSet<String>(Arrays.asList("", "b")), (Object)ScopedNamespaceContextTest.getPrefixes((NamespaceContext)nc, "urn:ns1"));
    }

    public void testScope() {
        ScopedNamespaceContext nc = new ScopedNamespaceContext();
        nc.setPrefix("ns1", "urn:ns1");
        ScopedNamespaceContextTest.assertEquals((int)0, (int)nc.getFirstBindingInCurrentScope());
        ScopedNamespaceContextTest.assertEquals((int)1, (int)nc.getBindingsCount());
        nc.startScope();
        nc.setPrefix("ns2", "urn:ns2");
        ScopedNamespaceContextTest.assertEquals((int)1, (int)nc.getFirstBindingInCurrentScope());
        ScopedNamespaceContextTest.assertEquals((int)2, (int)nc.getBindingsCount());
        nc.startScope();
        nc.setPrefix("ns3", "urn:ns3");
        ScopedNamespaceContextTest.assertEquals((int)2, (int)nc.getFirstBindingInCurrentScope());
        ScopedNamespaceContextTest.assertEquals((int)3, (int)nc.getBindingsCount());
        ScopedNamespaceContextTest.assertEquals((String)"urn:ns1", (String)nc.getNamespaceURI("ns1"));
        ScopedNamespaceContextTest.assertEquals((String)"urn:ns2", (String)nc.getNamespaceURI("ns2"));
        ScopedNamespaceContextTest.assertEquals((String)"urn:ns3", (String)nc.getNamespaceURI("ns3"));
        ScopedNamespaceContextTest.assertEquals((String)"ns1", (String)nc.getPrefix(0));
        ScopedNamespaceContextTest.assertEquals((String)"urn:ns1", (String)nc.getNamespaceURI(0));
        ScopedNamespaceContextTest.assertEquals((String)"ns2", (String)nc.getPrefix(1));
        ScopedNamespaceContextTest.assertEquals((String)"urn:ns2", (String)nc.getNamespaceURI(1));
        ScopedNamespaceContextTest.assertEquals((String)"ns3", (String)nc.getPrefix(2));
        ScopedNamespaceContextTest.assertEquals((String)"urn:ns3", (String)nc.getNamespaceURI(2));
        nc.endScope();
        ScopedNamespaceContextTest.assertEquals((int)1, (int)nc.getFirstBindingInCurrentScope());
        ScopedNamespaceContextTest.assertEquals((int)2, (int)nc.getBindingsCount());
        ScopedNamespaceContextTest.assertEquals((String)"urn:ns1", (String)nc.getNamespaceURI("ns1"));
        ScopedNamespaceContextTest.assertEquals((String)"urn:ns2", (String)nc.getNamespaceURI("ns2"));
        ScopedNamespaceContextTest.assertEquals((String)"", (String)nc.getNamespaceURI("ns3"));
        nc.endScope();
        ScopedNamespaceContextTest.assertEquals((int)0, (int)nc.getFirstBindingInCurrentScope());
        ScopedNamespaceContextTest.assertEquals((int)1, (int)nc.getBindingsCount());
        ScopedNamespaceContextTest.assertEquals((String)"urn:ns1", (String)nc.getNamespaceURI("ns1"));
        ScopedNamespaceContextTest.assertEquals((String)"", (String)nc.getNamespaceURI("ns2"));
        ScopedNamespaceContextTest.assertEquals((String)"", (String)nc.getNamespaceURI("ns3"));
    }

    public void testMaskedPrefix() {
        ScopedNamespaceContext nc = new ScopedNamespaceContext();
        nc.setPrefix("p", "urn:ns1");
        nc.startScope();
        nc.setPrefix("p", "urn:ns2");
        ScopedNamespaceContextTest.assertEquals((String)"urn:ns2", (String)nc.getNamespaceURI("p"));
        ScopedNamespaceContextTest.assertNull((Object)nc.getPrefix("urn:ns1"));
        ScopedNamespaceContextTest.assertEquals(Collections.singleton("p"), (Object)ScopedNamespaceContextTest.getPrefixes((NamespaceContext)nc, "urn:ns2"));
        ScopedNamespaceContextTest.assertFalse((boolean)nc.getPrefixes("urn:ns1").hasNext());
        nc.endScope();
        ScopedNamespaceContextTest.assertEquals((String)"p", (String)nc.getPrefix("urn:ns1"));
        ScopedNamespaceContextTest.assertEquals(Collections.singleton("p"), (Object)ScopedNamespaceContextTest.getPrefixes((NamespaceContext)nc, "urn:ns1"));
    }

    public void testImplicitNamespaces() {
        NamespaceContextTestUtils.checkImplicitNamespaces((NamespaceContext)new ScopedNamespaceContext());
    }
}

