/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax.xop;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLStreamReader;
import junit.framework.TestCase;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.impl.builder.AttachmentsMimePartProvider;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.testutils.stax.XMLStreamReaderComparator;
import org.apache.axiom.ts.soap.MTOMSample;
import org.apache.axiom.util.stax.xop.MimePartProvider;
import org.apache.axiom.util.stax.xop.XOPDecodingStreamReader;
import org.apache.commons.codec.binary.Base64;

public class XOPDecodingStreamReaderTest
extends TestCase {
    private XMLStreamReader getXOPDecodingStreamReader() throws Exception {
        Attachments attachments = new Attachments(MTOMSample.SAMPLE1.getInputStream(), MTOMSample.SAMPLE1.getContentType());
        return new XOPDecodingStreamReader(StAXUtils.createXMLStreamReader((InputStream)attachments.getRootPartInputStream()), (MimePartProvider)new AttachmentsMimePartProvider(attachments));
    }

    public void testCompareToInlined() throws Exception {
        XMLStreamReader expected = StAXUtils.createXMLStreamReader((InputStream)MTOMSample.SAMPLE1.getInlinedMessage());
        XMLStreamReader actual = this.getXOPDecodingStreamReader();
        XMLStreamReaderComparator comparator = new XMLStreamReaderComparator(expected, actual);
        comparator.addPrefix("xop");
        comparator.compare();
        expected.close();
        actual.close();
    }

    public void testGetElementText() throws Exception {
        XMLStreamReader reader = this.getXOPDecodingStreamReader();
        while (!reader.isStartElement() || !reader.getLocalName().equals("image1")) {
            reader.next();
        }
        String base64 = reader.getElementText();
        byte[] data = Base64.decodeBase64((String)base64);
        ImageIO.read(new ByteArrayInputStream(data));
        reader.close();
    }
}

