/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax.xop;

import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import junit.framework.TestCase;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.impl.builder.AttachmentsMimePartProvider;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.testutils.stax.XMLStreamReaderComparator;
import org.apache.axiom.ts.soap.MTOMSample;
import org.apache.axiom.util.stax.xop.ContentIDGenerator;
import org.apache.axiom.util.stax.xop.MimePartProvider;
import org.apache.axiom.util.stax.xop.OptimizationPolicy;
import org.apache.axiom.util.stax.xop.XOPDecodingStreamReader;
import org.apache.axiom.util.stax.xop.XOPEncodingStreamReader;

public class XOPEncodingStreamReaderTest
extends TestCase {
    private static ContentIDGenerator contentIDGenerator = new ContentIDGenerator(){

        public String generateContentID(String existingContentID) {
            if (existingContentID == null) {
                TestCase.fail();
            }
            return existingContentID;
        }
    };

    public void test() throws Exception {
        Attachments[] attachments = new Attachments[2];
        XMLStreamReader[] soapPartReader = new XMLStreamReader[2];
        for (int i = 0; i < 2; ++i) {
            attachments[i] = new Attachments(MTOMSample.SAMPLE1.getInputStream(), MTOMSample.SAMPLE1.getContentType());
            soapPartReader[i] = StAXUtils.createXMLStreamReader((InputStream)attachments[i].getRootPartInputStream());
        }
        XOPEncodingStreamReader actual = new XOPEncodingStreamReader((XMLStreamReader)new XOPDecodingStreamReader(soapPartReader[1], (MimePartProvider)new AttachmentsMimePartProvider(attachments[1])), contentIDGenerator, OptimizationPolicy.DEFAULT);
        new XMLStreamReaderComparator(soapPartReader[0], (XMLStreamReader)actual).compare();
        for (int i = 0; i < 2; ++i) {
            soapPartReader[i].close();
        }
    }
}

