/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedList;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;

public class MIMEOutputUtils {
    private static byte[] CRLF = new byte[]{13, 10};

    public static void complete(OutputStream outStream, StringWriter writer, LinkedList binaryNodeList, String boundary, String contentId, String charSetEncoding, String SOAPContentType) {
        try {
            MIMEOutputUtils.startWritingMime(outStream, boundary);
            DataHandler dh = new DataHandler((Object)writer.toString(), "text/xml; charset=" + charSetEncoding);
            MimeBodyPart rootMimeBodyPart = new MimeBodyPart();
            rootMimeBodyPart.setDataHandler(dh);
            rootMimeBodyPart.addHeader("content-type", "application/xop+xml; charset=" + charSetEncoding + "; type=\"" + SOAPContentType + "\";");
            rootMimeBodyPart.addHeader("content-transfer-encoding", "binary");
            rootMimeBodyPart.addHeader("content-id", "<" + contentId + ">");
            MIMEOutputUtils.writeBodyPart(outStream, rootMimeBodyPart, boundary);
            Iterator binaryNodeIterator = binaryNodeList.iterator();
            while (binaryNodeIterator.hasNext()) {
                OMText binaryNode = (OMText)binaryNodeIterator.next();
                MIMEOutputUtils.writeBodyPart(outStream, MIMEOutputUtils.createMimeBodyPart(binaryNode.getContentID(), (DataHandler)binaryNode.getDataHandler()), boundary);
            }
            MIMEOutputUtils.finishWritingMime(outStream);
        }
        catch (IOException e) {
            throw new OMException("Error while writing to the OutputStream.", e);
        }
        catch (MessagingException e) {
            throw new OMException("Problem writing Mime Parts.", e);
        }
    }

    public static MimeBodyPart createMimeBodyPart(String contentID, DataHandler dataHandler) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDataHandler(dataHandler);
        mimeBodyPart.addHeader("content-id", "<" + contentID + ">");
        mimeBodyPart.addHeader("content-type", dataHandler.getContentType());
        mimeBodyPart.addHeader("content-transfer-encoding", "binary");
        return mimeBodyPart;
    }

    public static void writeMimeBoundary(OutputStream outStream, String boundary) throws IOException {
        outStream.write(new byte[]{45, 45});
        outStream.write(boundary.getBytes());
    }

    public static void startWritingMime(OutputStream outStream, String boundary) throws IOException {
        MIMEOutputUtils.writeMimeBoundary(outStream, boundary);
    }

    public static void writeBodyPart(OutputStream outStream, MimeBodyPart part, String boundary) throws IOException, MessagingException {
        outStream.write(CRLF);
        part.writeTo(outStream);
        outStream.write(CRLF);
        MIMEOutputUtils.writeMimeBoundary(outStream, boundary);
    }

    public static void finishWritingMime(OutputStream outStream) throws IOException {
        outStream.write(new byte[]{45, 45});
    }

    public static void writeSOAPWithAttachmentsMessage(StringWriter writer, OutputStream outputStream, Attachments attachments, OMOutputFormat format) {
        try {
            String SOAPContentType = format.isSOAP11() ? "text/xml" : "application/soap+xml";
            MIMEOutputUtils.startWritingMime(outputStream, format.getMimeBoundary());
            DataHandler dh = new DataHandler((Object)writer.toString(), "text/xml; charset=" + format.getCharSetEncoding());
            MimeBodyPart rootMimeBodyPart = new MimeBodyPart();
            rootMimeBodyPart.setDataHandler(dh);
            rootMimeBodyPart.addHeader("content-type", SOAPContentType + "; charset=" + format.getCharSetEncoding());
            rootMimeBodyPart.addHeader("content-transfer-encoding", "8bit");
            rootMimeBodyPart.addHeader("content-id", "<" + format.getRootContentId() + ">");
            MIMEOutputUtils.writeBodyPart(outputStream, rootMimeBodyPart, format.getMimeBoundary());
            Iterator attachmentIDIterator = attachments.getContentIDSet().iterator();
            while (attachmentIDIterator.hasNext()) {
                String contentID = (String)attachmentIDIterator.next();
                DataHandler dataHandler = attachments.getDataHandler(contentID);
                MIMEOutputUtils.writeBodyPart(outputStream, MIMEOutputUtils.createMimeBodyPart(contentID, dataHandler), format.getMimeBoundary());
            }
            MIMEOutputUtils.finishWritingMime(outputStream);
        }
        catch (IOException e) {
            throw new OMException("Error while writing to the OutputStream.", e);
        }
        catch (MessagingException e) {
            throw new OMException("Problem writing Mime Parts.", e);
        }
    }
}

