/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.AttributeMap;
import org.apache.axiom.om.impl.dom.ChildNode;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DOMStAXWrapper;
import org.apache.axiom.om.impl.dom.DOMUtil;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.NamespaceImpl;
import org.apache.axiom.om.impl.dom.NodeListImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.apache.axiom.om.impl.traverse.OMChildElementIterator;
import org.apache.axiom.om.impl.util.EmptyIterator;
import org.apache.axiom.om.impl.util.OMSerializerUtil;
import org.apache.axiom.om.util.ElementHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends ParentNode
implements Element,
OMElement,
OMConstants {
    private int lineNumber;
    protected OMNamespace namespace;
    protected String localName;
    private AttributeMap attributes;
    private HashMap namespaces;
    private static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    public ElementImpl(DocumentImpl ownerDocument, String tagName, OMFactory factory) {
        super(ownerDocument, factory);
        this.localName = tagName;
        this.attributes = new AttributeMap(this);
        this.done = true;
    }

    public ElementImpl(DocumentImpl ownerDocument, String tagName, NamespaceImpl ns, OMFactory factory) {
        super(ownerDocument, factory);
        this.localName = tagName;
        this.namespace = ns;
        this.declareNamespace(ns);
        this.attributes = new AttributeMap(this);
        this.done = true;
    }

    public ElementImpl(DocumentImpl ownerDocument, String tagName, NamespaceImpl ns, OMXMLParserWrapper builder, OMFactory factory) {
        super(ownerDocument, factory);
        this.localName = tagName;
        this.namespace = ns;
        this.builder = builder;
        this.declareNamespace(ns);
        this.attributes = new AttributeMap(this);
    }

    public ElementImpl(ParentNode parentNode, String tagName, NamespaceImpl ns, OMFactory factory) {
        this((DocumentImpl)parentNode.getOwnerDocument(), tagName, ns, factory);
        parentNode.addChild((OMNode)this);
        this.done = true;
    }

    public ElementImpl(ParentNode parentNode, String tagName, NamespaceImpl ns, OMXMLParserWrapper builder, OMFactory factory) {
        this(tagName, ns, builder, factory);
        if (parentNode != null) {
            this.ownerNode = (DocumentImpl)parentNode.getOwnerDocument();
            this.isOwned(true);
            parentNode.addChild((OMNode)this);
        }
    }

    public ElementImpl(String tagName, NamespaceImpl ns, OMXMLParserWrapper builder, OMFactory factory) {
        this(factory);
        this.localName = tagName;
        this.namespace = ns;
        this.builder = builder;
        if (ns != null) {
            this.declareNamespace(ns);
        }
        this.attributes = new AttributeMap(this);
    }

    public ElementImpl(OMFactory factory) {
        super(factory);
        this.ownerNode = ((OMDOMFactory)factory).getDocument();
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        if (this.namespace != null) {
            if (this.namespace.getPrefix() == null || "".equals(this.namespace.getPrefix())) {
                return this.localName;
            }
            return this.namespace.getPrefix() + ":" + this.localName;
        }
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.namespace != null ? this.namespace.getNamespaceURI() : null;
    }

    public int getType() throws OMException {
        return 1;
    }

    public void setType(int nodeType) throws OMException {
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public void removeAttribute(String name) throws DOMException {
        String namespacePrefix;
        if (this.isReadonly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (name.startsWith("xmlns") && this.findNamespaceURI(namespacePrefix = DOMUtil.getLocalName(name)) != null) {
            this.removeNamespace(namespacePrefix);
        }
        if (this.attributes != null) {
            this.attributes.removeNamedItem(name);
        }
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        if (this.isReadonly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            if (this.namespaces != null) {
                this.namespaces.remove(DOMUtil.getLocalName(localName));
            }
        } else if (this.attributes != null) {
            this.attributes.removeNamedItemNS(namespaceURI, localName);
        }
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (this.isReadonly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (this.attributes == null || this.attributes.getNamedItem(oldAttr.getName()) == null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        return (AttrImpl)this.attributes.removeNamedItem(oldAttr.getName());
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItem(name);
        return attr != null ? attr.getValue() : "";
    }

    public Attr getAttributeNode(String name) {
        return this.attributes == null ? null : (AttrImpl)this.attributes.getNamedItem(name);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        if (this.attributes == null) {
            return "";
        }
        Attr attributeNodeNS = this.getAttributeNodeNS(namespaceURI, localName);
        return attributeNodeNS == null ? "" : attributeNodeNS.getValue();
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        if (namespaceURI == "http://www.w3.org/2000/xmlns/") {
            OMNamespace ns = this.findNamespaceURI(localName);
            String nsuri = ns != null ? ns.getNamespaceURI() : "";
            AttrImpl namespaceAttr = new AttrImpl(this.ownerNode, localName, nsuri, this.factory);
            NamespaceImpl xmlNs = new NamespaceImpl("http://www.w3.org/2000/xmlns/");
            namespaceAttr.setOMNamespace(xmlNs);
            return namespaceAttr;
        }
        return this.attributes == null ? null : (Attr)this.attributes.getNamedItemNS(namespaceURI, localName);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        AttrImpl attrImpl = (AttrImpl)attr;
        if (attrImpl.isOwned() && !this.getOwnerDocument().equals(attr.getOwnerDocument())) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, msg);
        }
        if (this.isReadonly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (attrImpl.isUsed()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INUSE_ATTRIBUTE_ERR", null);
            throw new DOMException(10, msg);
        }
        if (attr.getNodeName().startsWith("xmlns:")) {
            this.declareNamespace(attr.getNodeValue(), DOMUtil.getLocalName(attr.getName()));
            return attr;
        }
        if (attr.getNodeName().equals("xmlns")) {
            this.declareDefaultNamespace(attr.getValue());
            return attr;
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this);
        }
        return (Attr)this.attributes.setNamedItem(attr);
    }

    public void setAttribute(String name, String value) throws DOMException {
        if (!DOMUtil.isValidChras(name)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        if (name.startsWith("xmlns:")) {
            this.declareNamespace(value, DOMUtil.getLocalName(name));
        } else if (name.equals("xmlns")) {
            this.declareDefaultNamespace(value);
        } else {
            this.setAttributeNode(new AttrImpl(this.ownerNode, name, value, this.factory));
        }
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        if (attr.getNamespaceURI() != null && attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
            this.declareNamespace(attr.getName(), attr.getValue());
            return attr;
        }
        AttrImpl attrImpl = (AttrImpl)attr;
        if (attrImpl.isOwned() && !this.getOwnerDocument().equals(attr.getOwnerDocument())) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, msg);
        }
        if (this.isReadonly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (attrImpl.isUsed()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INUSE_ATTRIBUTE_ERR", null);
            throw new DOMException(10, msg);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this);
        }
        if (attr.getNamespaceURI() != null && this.findNamespace(attr.getNamespaceURI(), attr.getPrefix()) == null) {
            this.declareNamespace(new NamespaceImpl(attr.getNamespaceURI(), attr.getPrefix()));
        }
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        if (namespaceURI != null && !"".equals(namespaceURI)) {
            if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                this.declareNamespace(value, DOMUtil.getLocalName(qualifiedName));
            } else {
                AttrImpl attr = new AttrImpl(this.ownerNode, DOMUtil.getLocalName(qualifiedName), value, this.factory);
                attr.setOMNamespace(new NamespaceImpl(namespaceURI, DOMUtil.getPrefix(qualifiedName)));
                this.setAttributeNodeNS(attr);
            }
        } else {
            this.setAttribute(DOMUtil.getLocalName(qualifiedName), value);
        }
    }

    private OMAttribute addAttribute(String namespaceURI, String qualifiedName, String value) throws DOMException {
        if (!DOMUtil.isValidChras(qualifiedName)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        if (this.isReadonly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this);
        }
        if (namespaceURI != null) {
            if (!DOMUtil.isValidNamespace(namespaceURI, qualifiedName)) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                throw new DOMException(14, msg);
            }
            Attr attributeNode = this.getAttributeNodeNS(namespaceURI, DOMUtil.getLocalName(qualifiedName));
            if (attributeNode != null) {
                AttrImpl tempAttr = (AttrImpl)attributeNode;
                tempAttr.setOMNamespace(new NamespaceImpl(namespaceURI, DOMUtil.getPrefix(qualifiedName)));
                tempAttr.setAttributeValue(value);
                this.attributes.setNamedItem(tempAttr);
                return tempAttr;
            }
            NamespaceImpl ns = new NamespaceImpl(namespaceURI, DOMUtil.getPrefix(qualifiedName));
            AttrImpl attr = new AttrImpl((DocumentImpl)this.getOwnerDocument(), DOMUtil.getLocalName(qualifiedName), ns, value, this.factory);
            this.attributes.setNamedItem(attr);
            return attr;
        }
        Attr attributeNode = this.getAttributeNode(qualifiedName);
        if (attributeNode != null) {
            AttrImpl tempAttr = (AttrImpl)attributeNode;
            tempAttr.setAttributeValue(value);
            this.attributes.setNamedItem(tempAttr);
            return tempAttr;
        }
        AttrImpl attr = new AttrImpl((DocumentImpl)this.getOwnerDocument(), qualifiedName, value, this.factory);
        this.attributes.setNamedItem(attr);
        return attr;
    }

    public boolean hasAttributes() {
        boolean flag = false;
        if (this.attributes != null) {
            flag = this.attributes.getLength() > 0;
        }
        boolean bl = flag = this.namespace != null;
        if (!flag) {
            if (this.namespaces != null) {
                flag = !this.namespaces.isEmpty();
            } else if (this.namespace != null) {
                flag = true;
            }
        }
        return flag;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new NodeListImpl(this, namespaceURI, localName);
    }

    public NodeList getElementsByTagName(String name) {
        return new NodeListImpl(this, name);
    }

    public OMAttribute addAttribute(OMAttribute attr) {
        OMNamespace namespace = attr.getNamespace();
        if (namespace != null && namespace.getNamespaceURI() != null && !"".equals(namespace.getNamespaceURI()) && this.findNamespace(namespace.getNamespaceURI(), namespace.getPrefix()) == null) {
            this.declareNamespace(namespace.getNamespaceURI(), namespace.getPrefix());
        }
        if (attr.getNamespace() != null) {
            return (AttrImpl)this.setAttributeNode((Attr)attr);
        }
        return (AttrImpl)this.setAttributeNodeNS((Attr)attr);
    }

    public OMAttribute addAttribute(String attributeName, String value, OMNamespace ns) {
        if (ns != null && this.findNamespace(ns.getNamespaceURI(), ns.getPrefix()) != null) {
            this.declareNamespace(ns);
        }
        if (ns != null) {
            return this.addAttribute(ns.getNamespaceURI(), ns.getPrefix() + ":" + attributeName, value);
        }
        return this.addAttribute(null, attributeName, value);
    }

    public OMNamespace declareNamespace(OMNamespace namespace) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap(5);
        }
        if (namespace != null) {
            String prefix = namespace.getPrefix();
            if ("".equals(prefix)) {
                namespace = this.declareDefaultNamespace(namespace.getNamespaceURI());
            } else if (prefix == null) {
                prefix = OMSerializerUtil.getNextNSPrefix();
                namespace = new NamespaceImpl(namespace.getNamespaceURI(), prefix);
            }
            if (!namespace.getPrefix().startsWith("xmlns")) {
                this.namespaces.put(namespace.getPrefix(), namespace);
            }
        }
        return namespace;
    }

    public OMNamespace declareNamespace(String uri, String prefix) {
        if ("".equals(prefix)) {
            prefix = OMSerializerUtil.getNextNSPrefix();
        }
        NamespaceImpl ns = new NamespaceImpl(uri, prefix);
        return this.declareNamespace(ns);
    }

    public OMNamespace declareDefaultNamespace(String uri) {
        NamespaceImpl ns = new NamespaceImpl(uri, "");
        if (this.namespaces == null) {
            this.namespaces = new HashMap(5);
        }
        this.namespaces.put("", ns);
        return ns;
    }

    public OMNamespace getDefaultNamespace() {
        NamespaceImpl defaultNS;
        if (this.namespaces != null && (defaultNS = (NamespaceImpl)this.namespaces.get("")) != null) {
            return defaultNS;
        }
        if (this.parentNode instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)this.parentNode;
            element.getDefaultNamespace();
        }
        return null;
    }

    public OMNamespace findNamespace(String uri, String prefix) {
        OMNamespace namespace = this.findDeclaredNamespace(uri, prefix);
        if (namespace != null) {
            return namespace;
        }
        if (this.parentNode != null && this.parentNode instanceof OMElement) {
            namespace = ((ElementImpl)this.parentNode).findNamespace(uri, prefix);
        }
        if (namespace == null && uri != null && prefix != null && prefix.equals("xml") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
            this.declareNamespace("http://www.w3.org/XML/1998/namespace", "xml");
            namespace = this.findNamespace(uri, prefix);
        }
        return namespace;
    }

    public OMNamespace findNamespaceURI(String prefix) {
        OMNamespace ns;
        OMNamespace oMNamespace = ns = this.namespaces == null ? null : (OMNamespace)this.namespaces.get(prefix);
        if (ns == null && this.parentNode instanceof OMElement) {
            ns = ((OMElement)this.parentNode).findNamespaceURI(prefix);
        }
        return ns;
    }

    private OMNamespace findDeclaredNamespace(String uri, String prefix) {
        if (uri == null) {
            return null;
        }
        if (prefix != null && prefix.equals("xml") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return new NamespaceImpl(uri, prefix);
        }
        if (this.namespaces == null) {
            return null;
        }
        if (prefix == null || "".equals(prefix)) {
            Iterator namespaceListIterator = this.namespaces.values().iterator();
            while (namespaceListIterator.hasNext()) {
                OMNamespace omNamespace = (OMNamespace)namespaceListIterator.next();
                String nsURI = omNamespace.getNamespaceURI();
                if (nsURI == null || !nsURI.equals(uri)) continue;
                return omNamespace;
            }
        } else {
            OMNamespace namespace = (OMNamespace)this.namespaces.get(prefix);
            if (namespace != null && uri.equalsIgnoreCase(namespace.getNamespaceURI())) {
                return namespace;
            }
        }
        return null;
    }

    public OMAttribute getAttribute(QName qname) {
        if (this.attributes == null) {
            return null;
        }
        if (qname.getNamespaceURI() == null || qname.getNamespaceURI().equals("")) {
            return (AttrImpl)this.getAttributeNode(qname.getLocalPart());
        }
        return (AttrImpl)this.getAttributeNodeNS(qname.getNamespaceURI(), qname.getLocalPart());
    }

    public String getAttributeValue(QName qname) {
        OMAttribute attr = this.getAttribute(qname);
        return attr == null ? null : attr.getAttributeValue();
    }

    public OMXMLParserWrapper getBuilder() {
        return this.builder;
    }

    public OMElement getFirstElement() {
        for (OMNode node = this.getFirstOMChild(); node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1) continue;
            return (OMElement)node;
        }
        return null;
    }

    public OMNamespace getNamespace() throws OMException {
        return this.namespace != null ? this.namespace : this.getDefaultNamespace();
    }

    public QName getQName() {
        QName qName = this.namespace != null ? (this.namespace.getPrefix() != null ? new QName(this.namespace.getNamespaceURI(), this.localName, this.namespace.getPrefix()) : new QName(this.namespace.getNamespaceURI(), this.localName)) : new QName(this.localName);
        return qName;
    }

    public String getText() {
        String childText = "";
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            OMText textNode;
            if (child.getType() != 4 || (textNode = (OMText)child).getText() == null || "".equals(textNode.getText())) continue;
            childText = childText + textNode.getText();
        }
        return childText;
    }

    public QName getTextAsQName() {
        String childText = "";
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            OMText textNode;
            if (child.getType() != 4 || (textNode = (OMText)child).getText() == null || "".equals(textNode.getText())) continue;
            String namespaceURI = textNode.getTextAsQName().getNamespaceURI();
            if (namespaceURI != null && !"".equals(namespaceURI)) {
                return textNode.getTextAsQName();
            }
            childText = childText + textNode.getText();
        }
        return new QName(childText);
    }

    public void removeAttribute(OMAttribute attr) {
        this.removeAttributeNode((AttrImpl)attr);
    }

    public void setBuilder(OMXMLParserWrapper wrapper) {
        this.builder = wrapper;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void setNamespace(OMNamespace namespace) {
        this.namespace = namespace;
    }

    public void setNamespaceWithNoFindInCurrentScope(OMNamespace namespace) {
        this.namespace = namespace;
    }

    public void setText(String text) {
        if (this.isReadonly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            if (child.getType() != 4) continue;
            child.detach();
        }
        TextImpl textNode = (TextImpl)this.ownerNode.createTextNode(text);
        this.addChild((OMNode)textNode);
    }

    public void setText(QName text) {
        throw new UnsupportedOperationException();
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, true);
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, false);
    }

    protected void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        if (!cache) {
            OMSerializerUtil.serializeStartpart((OMElement)this, (XMLStreamWriter)writer);
            Iterator children = this.getChildren();
            while (children.hasNext()) {
                ((OMNodeEx)children.next()).internalSerialize(writer);
            }
            OMSerializerUtil.serializeEndpart((XMLStreamWriter)writer);
        } else if (this.done) {
            OMSerializerUtil.serializeStartpart((OMElement)this, (XMLStreamWriter)writer);
            ChildNode child = this.firstChild;
            while (child != null && (!(child instanceof OMElement) || child.isComplete())) {
                child.internalSerializeAndConsume(writer);
                child = child.nextSibling;
            }
            if (child != null) {
                OMElement element = (OMElement)child;
                element.getBuilder().setCache(false);
                OMSerializerUtil.serializeByPullStream((OMElement)element, (XMLStreamWriter)writer, (boolean)cache);
            }
            OMSerializerUtil.serializeEndpart((XMLStreamWriter)writer);
        } else {
            OMSerializerUtil.serializeByPullStream((OMElement)this, (XMLStreamWriter)writer, (boolean)cache);
        }
    }

    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return this.getXMLStreamReader(false);
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.getXMLStreamReader(true);
    }

    private XMLStreamReader getXMLStreamReader(boolean cache) {
        if (this.builder == null && !cache) {
            throw new UnsupportedOperationException("This element was not created in a manner to be switched");
        }
        if (this.builder != null && this.builder.isCompleted() && !cache) {
            throw new UnsupportedOperationException("The parser is already consumed!");
        }
        return new DOMStAXWrapper(this.builder, this, cache);
    }

    public String toStringWithConsume() throws XMLStreamException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.serializeAndConsume(baos);
        return new String(baos.toByteArray());
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.serialize(baos);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Can not serialize OM Element " + this.getLocalName(), e);
        }
        return new String(baos.toByteArray());
    }

    public Iterator getChildElements() {
        return new OMChildElementIterator(this.getFirstElement());
    }

    public Iterator getAllDeclaredNamespaces() throws OMException {
        if (this.namespaces == null) {
            return null;
        }
        return this.namespaces.values().iterator();
    }

    public Iterator getAllAttributes() {
        if (this.attributes == null) {
            return EMPTY_ITERATOR;
        }
        ArrayList<OMAttribute> list = new ArrayList<OMAttribute>();
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            OMAttribute item = (OMAttribute)this.attributes.getItem(i);
            if (item.getNamespace() != null && item.getNamespace() != null && "http://www.w3.org/2000/xmlns/".equals(item.getNamespace().getNamespaceURI())) continue;
            list.add(item);
        }
        return list.iterator();
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.namespace == null ? null : this.namespace.getPrefix();
    }

    protected void setOwnerDocument(DocumentImpl document) {
        this.ownerNode = document;
        this.isOwned(true);
        if (document.firstChild == null) {
            document.firstChild = this;
        }
    }

    public QName resolveQName(String qname) {
        ElementHelper helper = new ElementHelper((OMElement)this);
        return helper.resolveQName(qname);
    }

    public OMElement cloneOMElement() {
        return (ElementImpl)this.cloneNode(true);
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Node cloneNode(boolean deep) {
        ElementImpl newnode = (ElementImpl)super.cloneNode(deep);
        if (this.attributes != null) {
            newnode.attributes = (AttributeMap)this.attributes.cloneMap(newnode);
        }
        return newnode;
    }

    public NamedNodeMap getAttributes() {
        AttributeMap attributeMap = new AttributeMap(this);
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            attributeMap.addItem((Attr)this.attributes.getItem(i));
        }
        if (this.namespaces != null) {
            Iterator nsDecls = this.namespaces.keySet().iterator();
            while (nsDecls.hasNext()) {
                String prefix = (String)nsDecls.next();
                if (prefix == null || "".equals(prefix) || prefix.equals("xmlns")) continue;
                OMNamespace ns = (OMNamespace)this.namespaces.get(prefix);
                AttrImpl attr = new AttrImpl(this.ownerNode, prefix, ns.getNamespaceURI(), this.factory);
                attr.setOMNamespace(new NamespaceImpl("http://www.w3.org/2000/xmlns/", "xmlns"));
                attributeMap.addItem(attr);
            }
            if (this.namespace != null && (this.namespace.getPrefix() == null || "".equals(this.namespace.getPrefix())) && this.namespace.getNamespaceURI() != null) {
                boolean parentHasSameDefaultNS;
                boolean bl = parentHasSameDefaultNS = this.parentNode != null && this.parentNode.getNamespaceURI() == this.getNamespaceURI() && (this.parentNode.getPrefix() == null || this.parentNode.getPrefix().equals(""));
                if (!parentHasSameDefaultNS) {
                    AttrImpl attr = new AttrImpl(this.ownerNode, "xmlns", this.namespace.getNamespaceURI(), this.factory);
                    attr.setOMNamespace(new NamespaceImpl("http://www.w3.org/2000/xmlns/", "xmlns"));
                    attributeMap.addItem(attr);
                }
            }
        }
        return attributeMap;
    }

    public String getNamespaceURI(String prefix) {
        OMNamespace ns = this.findNamespaceURI(prefix);
        return ns != null ? ns.getNamespaceURI() : null;
    }

    public boolean removeNamespace(String prefix) {
        Object ns = this.namespaces.get(prefix);
        if (ns != null) {
            this.namespaces.remove(prefix);
            return true;
        }
        return false;
    }

    public OMNode getNextOMSibling() throws OMException {
        while (!this.done) {
            int token = this.builder.next();
            if (token != 8) continue;
            throw new OMException();
        }
        return super.getNextOMSibling();
    }

    public void discard() throws OMException {
        if (this.done) {
            this.detach();
        } else {
            this.builder.discard((OMElement)this);
        }
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        if (this.isReadonly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        AttrImpl tempAttr = (AttrImpl)this.getAttributeNode(name);
        if (tempAttr == null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        this.updateIsId(isId, tempAttr);
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        if (this.isReadonly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        AttrImpl tempAttr = (AttrImpl)this.getAttributeNodeNS(namespaceURI, localName);
        if (tempAttr == null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        this.updateIsId(isId, tempAttr);
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        if (this.isReadonly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        Iterator attrIter = this.getAllAttributes();
        AttrImpl tempAttr = null;
        while (attrIter.hasNext()) {
            AttrImpl attr = (AttrImpl)attrIter.next();
            if (!attr.equals(idAttr)) continue;
            tempAttr = attr;
            break;
        }
        if (tempAttr == null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        this.updateIsId(isId, tempAttr);
    }

    private void updateIsId(boolean isId, AttrImpl tempAttr) {
        tempAttr.isId = isId;
        if (isId) {
            this.ownerNode.addIdAttr(tempAttr);
        } else {
            this.ownerNode.removeIdAttr(tempAttr);
        }
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("TODO");
    }

    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            OMNode node = (OMNode)iterator.next();
            node.buildWithAttachments();
        }
    }
}

