/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom.jaxp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOMImplementationImpl;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.apache.axiom.om.util.StAXUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOOMDocumentBuilder
extends DocumentBuilder {
    protected DOOMDocumentBuilder() {
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public boolean isValidating() {
        return true;
    }

    public DOMImplementation getDOMImplementation() {
        return new DOMImplementationImpl();
    }

    public Document newDocument() {
        OMDOMFactory factory = new OMDOMFactory();
        DocumentImpl documentImpl = new DocumentImpl(factory);
        documentImpl.setComplete(true);
        return documentImpl;
    }

    public void setEntityResolver(EntityResolver arg0) {
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        try {
            OMDOMFactory factory = new OMDOMFactory();
            XMLStreamReader reader = StAXUtils.createXMLStreamReader((Reader)inputSource.getCharacterStream());
            StAXOMBuilder builder = new StAXOMBuilder((OMFactory)factory, reader);
            DocumentImpl doc = (DocumentImpl)builder.getDocument();
            doc.close(true);
            return doc;
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public Document parse(InputStream is) throws SAXException, IOException {
        try {
            OMDOMFactory factory = new OMDOMFactory();
            XMLStreamReader reader = StAXUtils.createXMLStreamReader((InputStream)is);
            StAXOMBuilder builder = new StAXOMBuilder((OMFactory)factory, reader);
            DocumentImpl doc = (DocumentImpl)builder.getDocument();
            doc.close(true);
            return doc;
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(File file) throws SAXException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            Document document = this.parse(in);
            return document;
        }
        finally {
            in.close();
        }
    }

    public Document parse(InputStream is, String systemId) throws SAXException, IOException {
        throw new UnsupportedOperationException("TODO");
    }

    public Document parse(String uri) throws SAXException, IOException {
        throw new UnsupportedOperationException("TODO");
    }
}

