/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.TestCase;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class TransformTest
extends TestCase {
    public void testTransform() throws Exception {
        OMDOMFactory fac = new OMDOMFactory();
        OMDocument doc = fac.createOMDocument();
        OMElement element = fac.createOMElement(new QName("http://foo", "bar"));
        OMText text = fac.createOMText("test");
        element.addChild((OMNode)text);
        doc.addChild((OMNode)element);
        Document domDoc1 = ((ElementImpl)element).getOwnerDocument();
        TransformTest.assertNotNull((Object)domDoc1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(domDoc1);
        StreamResult result = new StreamResult(baos);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
        byte[] data = baos.toByteArray();
        String xml = new String(data, 0, data.length);
        System.out.println(xml);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document domDoc2 = db.parse(new InputSource(new StringReader(xml)));
        TransformTest.assertEquals((String)"http://foo", (String)domDoc2.getDocumentElement().getNamespaceURI());
        TransformTest.assertEquals((String)"bar", (String)domDoc2.getDocumentElement().getLocalName());
        TransformTest.assertEquals((String)"test", (String)domDoc2.getDocumentElement().getFirstChild().getNodeValue());
    }
}

