/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom.factory;

import javax.xml.namespace.QName;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMHierarchyException;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.CDATASectionImpl;
import org.apache.axiom.om.impl.dom.CommentImpl;
import org.apache.axiom.om.impl.dom.DocumentFragmentImpl;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.DocumentTypeImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NamespaceImpl;
import org.apache.axiom.om.impl.dom.OMDOMException;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.dom.ProcessingInstructionImpl;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axiom.om.impl.dom.TextNodeImpl;
import org.apache.axiom.om.impl.dom.factory.OMDOMMetaFactory;
import org.apache.axiom.om.impl.util.OMSerializerUtil;

public class OMDOMFactory
implements OMFactory {
    private final OMDOMMetaFactory metaFactory;
    protected DocumentImpl document;

    public OMDOMFactory(OMDOMMetaFactory metaFactory) {
        this.metaFactory = metaFactory;
    }

    public OMDOMFactory() {
        this(new OMDOMMetaFactory());
    }

    public OMDOMFactory(DocumentImpl doc) {
        this(new OMDOMMetaFactory());
        this.document = doc;
    }

    public OMMetaFactory getMetaFactory() {
        return this.metaFactory;
    }

    public OMDocument createOMDocument() {
        if (this.document == null) {
            this.document = new DocumentImpl(this);
        }
        return this.document;
    }

    public void setDocument(DocumentImpl document) {
        this.document = document;
    }

    public OMElement createOMElement(String localName, OMNamespace ns) {
        return new ElementImpl((DocumentImpl)this.createOMDocument(), localName, (NamespaceImpl)ns, (OMFactory)this);
    }

    public OMElement createOMElement(String localName, OMNamespace ns, OMContainer parent) throws OMDOMException {
        if (parent == null) {
            return new ElementImpl((DocumentImpl)this.createOMDocument(), localName, (NamespaceImpl)ns, (OMFactory)this);
        }
        switch (((ParentNode)parent).getNodeType()) {
            case 1: {
                return new ElementImpl((ElementImpl)parent, localName, (NamespaceImpl)ns, (OMFactory)this);
            }
            case 9: {
                DocumentImpl docImpl = (DocumentImpl)parent;
                ElementImpl elem = new ElementImpl(docImpl, localName, (NamespaceImpl)ns, (OMFactory)this);
                docImpl.appendChild(elem);
                return elem;
            }
            case 11: {
                DocumentFragmentImpl docFragImpl = (DocumentFragmentImpl)parent;
                return new ElementImpl((DocumentImpl)docFragImpl.getOwnerDocument(), localName, (NamespaceImpl)ns, (OMFactory)this);
            }
        }
        throw new OMDOMException("The parent container can only be an ELEMENT, DOCUMENT or a DOCUMENT FRAGMENT");
    }

    public OMElement createOMElement(String localName, OMNamespace ns, OMContainer parent, OMXMLParserWrapper builder) {
        switch (((ParentNode)parent).getNodeType()) {
            case 1: {
                ElementImpl parentElem = (ElementImpl)parent;
                ElementImpl elem = new ElementImpl((DocumentImpl)parentElem.getOwnerDocument(), localName, (NamespaceImpl)ns, builder, (OMFactory)this);
                parentElem.appendChild(elem);
                return elem;
            }
            case 9: {
                DocumentImpl docImpl = (DocumentImpl)parent;
                ElementImpl elem2 = new ElementImpl(docImpl, localName, (NamespaceImpl)ns, builder, (OMFactory)this);
                docImpl.appendChild(elem2);
                return elem2;
            }
            case 11: {
                DocumentFragmentImpl docFragImpl = (DocumentFragmentImpl)parent;
                return new ElementImpl((DocumentImpl)docFragImpl.getOwnerDocument(), localName, (NamespaceImpl)ns, builder, (OMFactory)this);
            }
        }
        throw new OMDOMException("The parent container can only be an ELEMENT, DOCUMENT or a DOCUMENT FRAGMENT");
    }

    public OMElement createOMElement(OMDataSource source, String localName, OMNamespace ns, OMContainer parent) {
        throw new UnsupportedOperationException("Not supported for DOM");
    }

    public OMSourcedElement createOMElement(OMDataSource source, String localName, OMNamespace ns) {
        throw new UnsupportedOperationException("Not supported for DOM");
    }

    public OMSourcedElement createOMElement(OMDataSource source, QName qname) {
        throw new UnsupportedOperationException("Not supported for DOM");
    }

    public OMElement createOMElement(String localName, String namespaceURI, String prefix) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI must not be null");
        }
        if (namespaceURI.length() == 0) {
            if (prefix != null && prefix.length() > 0) {
                throw new IllegalArgumentException("Cannot create a prefixed element with an empty namespace name");
            }
            return this.createOMElement(localName, null);
        }
        return this.createOMElement(localName, this.createOMNamespace(namespaceURI, prefix));
    }

    public OMElement createOMElement(QName qname, OMContainer parent) throws OMException {
        NamespaceImpl ns;
        if (qname.getNamespaceURI().length() == 0) {
            if (qname.getPrefix().length() > 0) {
                throw new IllegalArgumentException("Cannot create a prefixed element with an empty namespace name");
            }
            ns = null;
        } else {
            ns = qname.getPrefix() != null ? new NamespaceImpl(qname.getNamespaceURI(), qname.getPrefix()) : new NamespaceImpl(qname.getNamespaceURI(), null);
        }
        return this.createOMElement(qname.getLocalPart(), ns, parent);
    }

    public OMElement createOMElement(QName qname) throws OMException {
        return this.createOMElement(qname, null);
    }

    public OMNamespace createOMNamespace(String uri, String prefix) {
        return new NamespaceImpl(uri, prefix);
    }

    public OMText createOMText(OMContainer parent, String text) {
        return this.createOMText(parent, text, 4);
    }

    public OMText createOMText(OMContainer parent, QName text) {
        return this.createOMText(parent, text, 4);
    }

    public OMText createOMText(OMContainer parent, QName text, int type) {
        TextImpl txt = new TextImpl(parent, text, type, (OMFactory)this);
        parent.addChild((OMNode)txt);
        return txt;
    }

    public OMText createOMText(OMContainer parent, String text, int type) {
        if (parent == null) {
            return this.createOMText(text, type);
        }
        if (parent instanceof DocumentImpl) {
            throw new OMHierarchyException("DOM doesn't support text nodes as children of a document");
        }
        DocumentImpl ownerDocument = (DocumentImpl)((ElementImpl)parent).getOwnerDocument();
        TextNodeImpl txt = type == 12 ? new CDATASectionImpl(ownerDocument, text, (OMFactory)this) : new TextImpl(ownerDocument, text, type, (OMFactory)this);
        parent.addChild((OMNode)txt);
        return txt;
    }

    public OMText createOMText(OMContainer parent, OMText source) {
        return new TextImpl(parent, (TextImpl)source, (OMFactory)this);
    }

    public OMText createOMText(OMContainer parent, char[] charArary, int type) {
        ElementImpl parentElem = (ElementImpl)parent;
        TextImpl txt = new TextImpl((DocumentImpl)parentElem.getOwnerDocument(), charArary, (OMFactory)this);
        parentElem.addChild((OMNode)txt);
        return txt;
    }

    public OMText createOMText(String s) {
        return new TextImpl(this.document, s, (OMFactory)this);
    }

    public OMText createOMText(String text, int type) {
        if (type == 12) {
            return new CDATASectionImpl(this.document, text, (OMFactory)this);
        }
        return new TextImpl(this.document, text, (OMFactory)this);
    }

    public OMText createOMText(String text, String mimeType, boolean optimize) {
        return new TextImpl(this.document, text, mimeType, optimize, (OMFactory)this);
    }

    public OMText createOMText(Object dataHandler, boolean optimize) {
        return new TextImpl(this.document, dataHandler, optimize, (OMFactory)this);
    }

    public OMText createOMText(String contentID, DataHandlerProvider dataHandlerProvider, boolean optimize) {
        return new TextImpl(this.document, contentID, dataHandlerProvider, optimize, (OMFactory)this);
    }

    public OMText createOMText(OMContainer parent, String s, String mimeType, boolean optimize) {
        TextImpl text = new TextImpl((DocumentImpl)((ElementImpl)parent).getOwnerDocument(), s, mimeType, optimize, (OMFactory)this);
        parent.addChild((OMNode)text);
        return text;
    }

    public OMText createOMText(String contentID, OMContainer parent, OMXMLParserWrapper builder) {
        TextImpl text = new TextImpl(contentID, parent, builder, (OMFactory)this);
        parent.addChild((OMNode)text);
        return text;
    }

    public OMAttribute createOMAttribute(String localName, OMNamespace ns, String value) {
        if (ns != null && ns.getPrefix() == null) {
            String namespaceURI = ns.getNamespaceURI();
            ns = namespaceURI.length() == 0 ? null : new NamespaceImpl(namespaceURI, OMSerializerUtil.getNextNSPrefix());
        }
        return new AttrImpl(this.getDocument(), localName, (OMNamespace)ns, value, this);
    }

    public OMDocType createOMDocType(OMContainer parent, String content) {
        DocumentTypeImpl docType = new DocumentTypeImpl(this.getDocument(), this);
        docType.setValue(content);
        parent.addChild((OMNode)docType);
        return docType;
    }

    public OMProcessingInstruction createOMProcessingInstruction(OMContainer parent, String piTarget, String piData) {
        ProcessingInstructionImpl pi = new ProcessingInstructionImpl(this.getDocumentFromParent(parent), piTarget, piData, this);
        if (parent != null) {
            parent.addChild((OMNode)pi);
        }
        return pi;
    }

    public OMComment createOMComment(OMContainer parent, String content) {
        CommentImpl comment = new CommentImpl(this.getDocumentFromParent(parent), content, this);
        if (parent != null) {
            parent.addChild((OMNode)comment);
        }
        return comment;
    }

    public DocumentImpl getDocument() {
        return (DocumentImpl)this.createOMDocument();
    }

    public OMDocument createOMDocument(OMXMLParserWrapper builder) {
        this.document = new DocumentImpl(builder, (OMFactory)this);
        return this.document;
    }

    private DocumentImpl getDocumentFromParent(OMContainer parent) {
        if (parent == null) {
            return (DocumentImpl)this.createOMDocument();
        }
        if (parent instanceof DocumentImpl) {
            return (DocumentImpl)parent;
        }
        return (DocumentImpl)((ParentNode)parent).getOwnerDocument();
    }
}

