/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.dom;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.common.AxiomContainerSupport;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.common.HeaderIterator;
import org.apache.axiom.soap.impl.common.MURoleChecker;
import org.apache.axiom.soap.impl.common.RoleChecker;
import org.apache.axiom.soap.impl.common.RolePlayerChecker;
import org.apache.axiom.soap.impl.dom.SOAPElement;
import org.apache.axiom.soap.impl.dom.SOAPEnvelopeImpl;

public abstract class SOAPHeaderImpl
extends SOAPElement
implements SOAPHeader {
    public SOAPHeaderImpl(SOAPEnvelope envelope, SOAPFactory factory) throws SOAPProcessingException {
        super((OMElement)envelope, "Header", true, factory);
    }

    public SOAPHeaderImpl(ParentNode parentNode, OMNamespace ns, OMXMLParserWrapper builder, OMFactory factory, boolean generateNSDecl) {
        super(parentNode, "Header", ns, builder, factory, generateNSDecl);
    }

    public SOAPHeaderBlock addHeaderBlock(String localName, OMNamespace ns) throws OMException {
        SOAPHeaderBlock soapHeaderBlock;
        if (ns == null || ns.getNamespaceURI().length() == 0) {
            throw new OMException("All the SOAP Header blocks should be namespace qualified");
        }
        OMNamespace namespace = this.findNamespace(ns.getNamespaceURI(), ns.getPrefix());
        if (namespace != null) {
            ns = namespace;
        }
        try {
            soapHeaderBlock = ((SOAPFactory)this.getOMFactory()).createSOAPHeaderBlock(localName, ns, (SOAPHeader)this);
        }
        catch (SOAPProcessingException e) {
            throw new OMException((Throwable)e);
        }
        ((OMNodeEx)soapHeaderBlock).setComplete(true);
        return soapHeaderBlock;
    }

    public SOAPHeaderBlock addHeaderBlock(QName qname) throws OMException {
        return this.addHeaderBlock(qname.getLocalPart(), this.getOMFactory().createOMNamespace(qname.getNamespaceURI(), qname.getPrefix()));
    }

    public Iterator getHeadersToProcess(RolePlayer rolePlayer) {
        return new HeaderIterator(this, new RolePlayerChecker(rolePlayer));
    }

    public Iterator getHeadersToProcess(RolePlayer rolePlayer, String namespace) {
        return new HeaderIterator(this, new RolePlayerChecker(rolePlayer, namespace));
    }

    public Iterator examineHeaderBlocks(String role) {
        return new HeaderIterator(this, new RoleChecker(role));
    }

    public abstract Iterator extractHeaderBlocks(String var1);

    public Iterator examineMustUnderstandHeaderBlocks(String actor) {
        return new HeaderIterator(this, new MURoleChecker(actor));
    }

    public Iterator examineAllHeaderBlocks() {
        return AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_OMContainer$getChildrenWithName((OMContainer)this, null);
    }

    public Iterator extractAllHeaderBlocks() {
        ArrayList<OMElement> result = new ArrayList<OMElement>();
        Iterator iter = this.getChildElements();
        while (iter.hasNext()) {
            OMElement headerBlock = (OMElement)iter.next();
            iter.remove();
            result.add(headerBlock);
        }
        return result.iterator();
    }

    public ArrayList getHeaderBlocksWithNSURI(String nsURI) {
        ArrayList<OMElement> headers = null;
        OMElement header = this.getFirstElement();
        if (header != null) {
            headers = new ArrayList<OMElement>();
        }
        OMElement node = header;
        while (node != null) {
            if (node.getType() == 1) {
                header = node;
                OMNamespace namespace = header.getNamespace();
                if (nsURI == null) {
                    if (namespace == null) {
                        headers.add(header);
                    }
                } else if (namespace != null && nsURI.equals(namespace.getNamespaceURI())) {
                    headers.add(header);
                }
            }
            node = node.getNextOMSibling();
        }
        return headers;
    }

    protected void checkParent(OMElement parent) throws SOAPProcessingException {
        if (!(parent instanceof SOAPEnvelopeImpl)) {
            throw new SOAPProcessingException("Expecting an implementation of SOAP Envelope as the parent. But received some other implementation");
        }
    }
}

