/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts;

import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.ts.AxiomTestCase;

public abstract class AxiomTestSuiteBuilder {
    protected final OMMetaFactory metaFactory;
    private final Set excludedTests = new HashSet();
    private TestSuite suite;

    public AxiomTestSuiteBuilder(OMMetaFactory metaFactory) {
        this.metaFactory = metaFactory;
    }

    public final void exclude(Class testClass) {
        this.excludedTests.add(testClass);
    }

    protected abstract void addTests();

    public final TestSuite build() {
        this.suite = new TestSuite();
        this.addTests();
        return this.suite;
    }

    protected final void addTest(AxiomTestCase test) {
        if (!this.excludedTests.contains(((Object)((Object)test)).getClass())) {
            this.suite.addTest((Test)test);
        }
    }
}

