/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.ts.ConformanceTestCase;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class TestSerializeToOutputStream
extends ConformanceTestCase {
    private final boolean cache;

    public TestSerializeToOutputStream(OMMetaFactory metaFactory, String file, boolean cache) {
        super(metaFactory, file);
        this.cache = cache;
        this.setName(this.getName() + " [cache=" + cache + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        byte[] control;
        ByteArrayOutputStream baos;
        InputStream in = this.getFileAsStream();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(in);
            baos = new ByteArrayOutputStream();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc.getDocumentElement()), new StreamResult(baos));
            control = baos.toByteArray();
        }
        finally {
            in.close();
        }
        in = this.getFileAsStream();
        try {
            OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (StAXParserConfiguration)StAXParserConfiguration.PRESERVE_CDATA_SECTIONS, (InputStream)in);
            try {
                OMElement element = builder.getDocumentElement();
                baos = new ByteArrayOutputStream();
                if (this.cache) {
                    element.serialize((OutputStream)baos);
                } else {
                    element.serializeAndConsume((OutputStream)baos);
                }
                this.assertXMLIdentical(this.compareXML(new InputSource(new ByteArrayInputStream(control)), new InputSource(new ByteArrayInputStream(baos.toByteArray()))), true);
                if (this.cache) {
                    TestSerializeToOutputStream.assertTrue((boolean)element.isComplete());
                } else {
                    TestSerializeToOutputStream.assertFalse((boolean)element.isComplete());
                }
            }
            finally {
                builder.close();
            }
        }
        finally {
            in.close();
        }
    }
}

