/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.factory;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.factory.OMElementCreator;

public class TestCreateOMElement
extends AxiomTestCase {
    private final OMElementCreator variant;

    public TestCreateOMElement(OMMetaFactory metaFactory, OMElementCreator variant) {
        super(metaFactory);
        this.variant = variant;
        this.setName(this.getName() + " [variant=" + variant.getName() + "]");
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("urn:ns", "ns");
        OMElement element = this.variant.createOMElement(factory, new QName("urn:ns", "test", "ns"));
        TestCreateOMElement.assertTrue((boolean)element.isComplete());
        TestCreateOMElement.assertEquals((String)"test", (String)element.getLocalName());
        TestCreateOMElement.assertEquals((Object)ns, (Object)element.getNamespace());
        Iterator it = element.getAllDeclaredNamespaces();
        TestCreateOMElement.assertTrue((boolean)it.hasNext());
        TestCreateOMElement.assertEquals((Object)ns, it.next());
        TestCreateOMElement.assertFalse((boolean)it.hasNext());
    }
}

