/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.node;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.ts.AxiomTestCase;

public class TestDetach
extends AxiomTestCase {
    private final boolean build;

    public TestDetach(OMMetaFactory metaFactory, boolean build) {
        super(metaFactory);
        this.build = build;
        this.setName(this.getName() + " [build=" + build + "]");
    }

    protected void runTest() throws Throwable {
        OMElement root = AXIOMUtil.stringToOM((OMFactory)this.metaFactory.getOMFactory(), (String)"<root><a/><b/><c/></root>");
        if (this.build) {
            root.build();
        } else {
            TestDetach.assertFalse((boolean)root.isComplete());
        }
        OMElement a = (OMElement)root.getFirstOMChild();
        TestDetach.assertEquals((String)"a", (String)a.getLocalName());
        OMElement b = (OMElement)a.getNextOMSibling();
        TestDetach.assertEquals((String)"b", (String)b.getLocalName());
        b.detach();
        TestDetach.assertNull((Object)b.getParent());
        OMElement c = (OMElement)a.getNextOMSibling();
        TestDetach.assertEquals((String)"c", (String)c.getLocalName());
        TestDetach.assertSame((Object)c, (Object)a.getNextOMSibling());
        TestDetach.assertSame((Object)a, (Object)c.getPreviousOMSibling());
        root.close(false);
    }
}

