/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap;

import java.io.InputStream;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.xml.sax.InputSource;

public class SOAPTestCase
extends AxiomTestCase {
    protected static final String MESSAGE = "message.xml";
    protected static final String MESSAGE_WITHOUT_HEADER = "message_without_header.xml";
    protected final SOAPSpec spec;
    protected SOAPFactory soapFactory;
    protected SOAPFactory altSoapFactory;

    public SOAPTestCase(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory);
        this.spec = spec;
        this.setName(this.getName() + " [" + spec.getName() + "]");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.soapFactory = this.spec.getFactory(this.metaFactory);
        this.altSoapFactory = this.spec.getAltFactory(this.metaFactory);
    }

    protected SOAPEnvelope getTestMessage(String name) {
        InputStream in = AbstractTestCase.getTestResource((String)("soap/" + this.spec.getName() + "/" + name));
        SOAPEnvelope envelope = (SOAPEnvelope)this.metaFactory.createSOAPModelBuilder(StAXParserConfiguration.SOAP, new InputSource(in)).getDocumentElement();
        SOAPTestCase.assertSame((Object)this.spec.getEnvelopeNamespaceURI(), (Object)((SOAPFactory)envelope.getOMFactory()).getSoapVersionURI());
        return envelope;
    }

    protected SOAPHeaderBlock createSOAPHeaderBlock() {
        OMNamespace namespace = this.soapFactory.createOMNamespace("http://www.example.org", "test");
        SOAPEnvelope soapEnvelope = this.soapFactory.createSOAPEnvelope();
        SOAPHeader soapHeader = this.soapFactory.createSOAPHeader(soapEnvelope);
        return this.soapFactory.createSOAPHeaderBlock("testHeaderBlock", namespace, soapHeader);
    }
}

