/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.testutils.XMLAssertEx;
import org.apache.axiom.testutils.conformance.ConformanceTestFile;
import org.apache.axiom.ts.ConformanceTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TestCreateOMBuilderFromDOM
extends ConformanceTestCase {
    private final Boolean expandEntityReferences;

    public TestCreateOMBuilderFromDOM(OMMetaFactory metaFactory, ConformanceTestFile file, Boolean expandEntityReferences) {
        super(metaFactory, file);
        this.expandEntityReferences = expandEntityReferences;
        if (expandEntityReferences != null) {
            this.addTestProperty("expandEntityReferences", expandEntityReferences.toString());
        }
    }

    protected void runTest() throws Throwable {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        Document document = documentBuilder.parse(this.file.getUrl().toString());
        OMXMLParserWrapper builder = this.expandEntityReferences == null ? OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (Source)new DOMSource(document)) : OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (Node)document, (boolean)this.expandEntityReferences);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        builder.getDocument().serialize((OutputStream)baos);
        XMLAssertEx.assertXMLIdentical((URL)this.file.getUrl(), (InputStream)new ByteArrayInputStream(baos.toByteArray()), (boolean)(this.expandEntityReferences == null ? false : this.expandEntityReferences));
    }
}

