/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.testutils.XMLAssertEx;
import org.apache.axiom.testutils.conformance.ConformanceTestFile;
import org.apache.axiom.ts.ConformanceTestCase;
import org.xml.sax.InputSource;

public class TestCreateOMBuilderFromSAXSource
extends ConformanceTestCase {
    private final Boolean expandEntityReferences;

    public TestCreateOMBuilderFromSAXSource(OMMetaFactory metaFactory, ConformanceTestFile file, Boolean expandEntityReferences) {
        super(metaFactory, file);
        this.expandEntityReferences = expandEntityReferences;
        if (expandEntityReferences != null) {
            this.addTestProperty("expandEntityReferences", expandEntityReferences.toString());
        }
    }

    protected void runTest() throws Throwable {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        SAXParser parser = factory.newSAXParser();
        SAXSource source = new SAXSource(parser.getXMLReader(), new InputSource(this.file.getUrl().toString()));
        OMXMLParserWrapper builder = this.expandEntityReferences == null ? OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (Source)source) : OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (SAXSource)source, (boolean)this.expandEntityReferences);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        builder.getDocument().serialize((OutputStream)baos);
        XMLAssertEx.assertXMLIdentical((URL)this.file.getUrl(), (InputStream)new ByteArrayInputStream(baos.toByteArray()), (boolean)(this.expandEntityReferences == null ? false : this.expandEntityReferences));
    }
}

