/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.testutils.InvocationCounter;
import org.apache.axiom.ts.AxiomTestCase;

public class TestInvalidXML
extends AxiomTestCase {
    public TestInvalidXML(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        XMLStreamReader originalReader = StAXUtils.createXMLStreamReader((InputStream)AbstractTestCase.getTestResource((String)"invalid_xml.xml"));
        InvocationCounter invocationCounter = new InvocationCounter();
        XMLStreamReader reader = (XMLStreamReader)invocationCounter.createProxy((Object)originalReader);
        OMXMLParserWrapper stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (XMLStreamReader)reader);
        Exception exception = null;
        while (exception == null || stAXOMBuilder.isCompleted()) {
            try {
                stAXOMBuilder.next();
            }
            catch (Exception e) {
                exception = e;
            }
        }
        TestInvalidXML.assertTrue((String)"Expected an exception because invalid_xml.xml is wrong", (exception != null ? 1 : 0) != 0);
        TestInvalidXML.assertTrue((invocationCounter.getInvocationCount() > 0 ? 1 : 0) != 0);
        invocationCounter.reset();
        Exception exception2 = null;
        try {
            stAXOMBuilder.next();
        }
        catch (Exception e) {
            exception2 = e;
        }
        TestInvalidXML.assertEquals((int)0, (int)invocationCounter.getInvocationCount());
        TestInvalidXML.assertTrue((String)"Expected a second exception because invalid_xml.xml is wrong", (exception2 != null ? 1 : 0) != 0);
        TestInvalidXML.assertTrue((String)("Expected the same exception. first=" + exception + " second=" + exception2), (boolean)exception.getMessage().equals(exception2.getMessage()));
    }
}

