/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.testutils.RandomUtils;
import org.apache.axiom.testutils.activation.RandomDataSource;
import org.apache.axiom.testutils.io.IOTestUtils;
import org.apache.axiom.ts.AxiomTestCase;

public class TestReadAttachmentBeforeRootPartComplete
extends AxiomTestCase {
    public TestReadAttachmentBeforeRootPartComplete(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement orgRoot = factory.createOMElement("root", null);
        OMElement orgChild1 = factory.createOMElement("child1", null, (OMContainer)orgRoot);
        RandomDataSource ds = new RandomDataSource(54321L, 4096L);
        orgChild1.addChild((OMNode)factory.createOMText((Object)new DataHandler((DataSource)ds), true));
        OMElement orgChild2 = factory.createOMElement("child2", null, (OMContainer)orgRoot);
        String s = RandomUtils.randomString((int)131072);
        orgChild2.setText(s);
        OMOutputFormat format = new OMOutputFormat();
        format.setDoOptimize(true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        orgRoot.serialize((OutputStream)baos, format);
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (StAXParserConfiguration)StAXParserConfiguration.NON_COALESCING, (Attachments)new Attachments((InputStream)new ByteArrayInputStream(baos.toByteArray()), format.getContentType()));
        OMElement root = builder.getDocumentElement();
        OMElement child1 = (OMElement)root.getFirstOMChild();
        OMText text = (OMText)child1.getFirstOMChild();
        TestReadAttachmentBeforeRootPartComplete.assertTrue((boolean)text.isBinary());
        DataHandler dh = (DataHandler)text.getDataHandler();
        IOTestUtils.compareStreams((InputStream)ds.getInputStream(), (InputStream)dh.getInputStream());
        OMElement child2 = (OMElement)child1.getNextOMSibling();
        TestReadAttachmentBeforeRootPartComplete.assertFalse((boolean)child2.isComplete());
        TestReadAttachmentBeforeRootPartComplete.assertEquals((String)s, (String)child2.getText());
    }
}

