/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.commons.io.input.CountingInputStream;

public class TestRootPartStreaming
extends AxiomTestCase {
    public TestRootPartStreaming(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement orgRoot = factory.createOMElement("root", null);
        for (int i = 0; i < 1000; ++i) {
            factory.createOMElement("child", null, (OMContainer)orgRoot).setText("Some text content");
        }
        OMOutputFormat format = new OMOutputFormat();
        format.setDoOptimize(true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        orgRoot.serialize((OutputStream)baos, format);
        CountingInputStream in = new CountingInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (StAXParserConfiguration)StAXParserConfiguration.DEFAULT, (Attachments)new Attachments((InputStream)in, format.getContentType()));
        OMElement root = builder.getDocumentElement();
        int count1 = in.getCount();
        XMLStreamReader reader = root.getXMLStreamReader(false);
        while (reader.hasNext()) {
            reader.next();
        }
        int count2 = in.getCount();
        TestRootPartStreaming.assertTrue((count1 < count2 / 2 ? 1 : 0) != 0);
    }
}

