/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.container;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.testutils.stax.XMLStreamReaderComparator;
import org.apache.axiom.ts.AxiomTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public interface BuilderFactory {
    public static final BuilderFactory PARSER = new BuilderFactory(){

        public void configureXMLStreamReaderComparator(XMLStreamReaderComparator comparator) {
        }

        public void addTestProperties(AxiomTestCase testCase) {
            testCase.addTestProperty("source", "parser");
        }

        public OMXMLParserWrapper getBuilder(OMMetaFactory metaFactory, InputSource inputSource) throws Exception {
            return metaFactory.createOMBuilder(metaFactory.getOMFactory(), AxiomTestCase.TEST_PARSER_CONFIGURATION, inputSource);
        }
    };
    public static final BuilderFactory DOM = new BuilderFactory(){

        public void configureXMLStreamReaderComparator(XMLStreamReaderComparator comparator) {
            comparator.setCompareEntityReplacementValue(false);
        }

        public void addTestProperties(AxiomTestCase testCase) {
            testCase.addTestProperty("source", "dom");
        }

        public OMXMLParserWrapper getBuilder(OMMetaFactory metaFactory, InputSource inputSource) throws Exception {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setExpandEntityReferences(false);
            Document document = dbf.newDocumentBuilder().parse(inputSource);
            return OMXMLBuilderFactory.createOMBuilder((OMFactory)metaFactory.getOMFactory(), (Node)document, (boolean)false);
        }
    };
    public static final BuilderFactory SAX = new BuilderFactory(){

        public void configureXMLStreamReaderComparator(XMLStreamReaderComparator comparator) {
            comparator.setCompareCharacterEncodingScheme(false);
            comparator.setCompareEncoding(false);
        }

        public void addTestProperties(AxiomTestCase testCase) {
            testCase.addTestProperty("source", "sax");
        }

        public OMXMLParserWrapper getBuilder(OMMetaFactory metaFactory, InputSource inputSource) throws Exception {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser parser = factory.newSAXParser();
            SAXSource source = new SAXSource(parser.getXMLReader(), inputSource);
            return OMXMLBuilderFactory.createOMBuilder((OMFactory)metaFactory.getOMFactory(), (SAXSource)source, (boolean)false);
        }
    };

    public void configureXMLStreamReaderComparator(XMLStreamReaderComparator var1);

    public void addTestProperties(AxiomTestCase var1);

    public OMXMLParserWrapper getBuilder(OMMetaFactory var1, InputSource var2) throws Exception;
}

