/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.container;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.container.SerializationMethod;
import org.xml.sax.InputSource;

public class SerializeToOutputStream
implements SerializationMethod {
    private final boolean cache;

    public SerializeToOutputStream(boolean cache) {
        this.cache = cache;
    }

    public void addTestProperties(AxiomTestCase testCase) {
        testCase.addTestProperty("method", this.cache ? "serialize" : "serializeAndConsume");
    }

    public InputSource serialize(OMContainer container) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.cache) {
            container.serialize((OutputStream)baos);
        } else {
            container.serializeAndConsume((OutputStream)baos);
        }
        return new InputSource(new ByteArrayInputStream(baos.toByteArray()));
    }

    public boolean isCaching() {
        return this.cache;
    }
}

