/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.container;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.testutils.XMLAssertEx;
import org.apache.axiom.testutils.conformance.ConformanceTestFile;
import org.apache.axiom.ts.ConformanceTestCase;
import org.apache.axiom.ts.om.container.OMContainerFactory;
import org.apache.axiom.ts.om.container.SAXSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class TestGetSAXSource
extends ConformanceTestCase {
    private final OMContainerFactory containerFactory;
    private final boolean cache;

    public TestGetSAXSource(OMMetaFactory metaFactory, ConformanceTestFile file, OMContainerFactory containerFactory, boolean cache) {
        super(metaFactory, file);
        this.containerFactory = containerFactory;
        this.cache = cache;
        containerFactory.addTestProperties(this);
        this.addTestProperty("cache", Boolean.toString(cache));
    }

    protected void runTest() throws Throwable {
        OMXMLParserWrapper builder = this.metaFactory.createOMBuilder(this.metaFactory.getOMFactory(), TEST_PARSER_CONFIGURATION, new InputSource(this.file.getUrl().toString()));
        SAXSource source = this.containerFactory.getContainer(builder).getSAXSource(this.cache);
        XMLReader xmlReader = source.getXMLReader();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SAXSerializer serializer = new SAXSerializer();
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputStream(out);
        xmlReader.setContentHandler((ContentHandler)((Object)serializer));
        xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)serializer);
        xmlReader.parse(source.getInputSource());
        InputSource control = this.containerFactory.getControl(this.file.getAsStream());
        InputSource test = new InputSource(new ByteArrayInputStream(out.toByteArray()));
        String systemId = new URL(this.file.getUrl(), "dummy.xml").toString();
        control.setSystemId(systemId);
        test.setSystemId(systemId);
        XMLAssertEx.assertXMLIdentical((InputSource)control, (InputSource)test, (boolean)false);
    }
}

