/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.container;

import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.testutils.conformance.ConformanceTestFile;
import org.apache.axiom.testutils.stax.XMLStreamReaderComparator;
import org.apache.axiom.ts.ConformanceTestCase;
import org.apache.axiom.ts.om.container.BuilderFactory;
import org.apache.axiom.ts.om.container.OMContainerFactory;
import org.xml.sax.InputSource;

public class TestGetXMLStreamReader
extends ConformanceTestCase {
    private final BuilderFactory builderFactory;
    private final OMContainerFactory containerFactory;
    private final boolean cache;

    public TestGetXMLStreamReader(OMMetaFactory metaFactory, ConformanceTestFile file, BuilderFactory builderFactory, OMContainerFactory containerFactory, boolean cache) {
        super(metaFactory, file);
        this.builderFactory = builderFactory;
        this.containerFactory = containerFactory;
        this.cache = cache;
        builderFactory.addTestProperties(this);
        containerFactory.addTestProperties(this);
        this.addTestProperty("cache", Boolean.toString(cache));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runTest() throws Throwable {
        InputStream in = this.file.getAsStream();
        try {
            XMLStreamReader expected = StAXUtils.createXMLStreamReader((StAXParserConfiguration)TEST_PARSER_CONFIGURATION, (String)this.file.getUrl().toString(), (InputStream)in);
            try {
                OMXMLParserWrapper builder = this.builderFactory.getBuilder(this.metaFactory, new InputSource(this.file.getUrl().toString()));
                try {
                    XMLStreamReader actual = this.containerFactory.getContainer(builder).getXMLStreamReader(this.cache);
                    XMLStreamReaderComparator comparator = new XMLStreamReaderComparator(this.containerFactory.filter(expected), this.containerFactory.filter(actual));
                    this.builderFactory.configureXMLStreamReaderComparator(comparator);
                    comparator.compare();
                }
                finally {
                    builder.close();
                }
            }
            finally {
                expected.close();
            }
        }
        finally {
            in.close();
        }
    }
}

