/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.container;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.testutils.conformance.ConformanceTestFile;
import org.apache.axiom.ts.ConformanceTestCase;
import org.apache.axiom.ts.om.container.OMContainerFactory;
import org.apache.axiom.ts.om.container.SerializationMethod;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.xml.sax.InputSource;

public class TestSerialize
extends ConformanceTestCase {
    private final OMContainerFactory containerFactory;
    private final SerializationMethod serializationMethod;

    public TestSerialize(OMMetaFactory metaFactory, ConformanceTestFile file, OMContainerFactory containerFactory, SerializationMethod serializationMethod) {
        super(metaFactory, file);
        this.containerFactory = containerFactory;
        this.serializationMethod = serializationMethod;
        containerFactory.addTestProperties(this);
        serializationMethod.addTestProperties(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        OMXMLParserWrapper builder = this.metaFactory.createOMBuilder(this.metaFactory.getOMFactory(), TEST_PARSER_CONFIGURATION, new InputSource(this.file.getUrl().toString()));
        try {
            OMContainer container = this.containerFactory.getContainer(builder);
            InputSource[] control = this.duplicateInputSource(this.containerFactory.getControl(this.file.getAsStream()));
            InputSource[] actual = this.duplicateInputSource(this.serializationMethod.serialize(container));
            try {
                String systemId = new URL(this.file.getUrl(), "dummy.xml").toString();
                control[0].setSystemId(systemId);
                actual[0].setSystemId(systemId);
                XMLAssert.assertXMLIdentical((Diff)XMLUnit.compareXML((InputSource)control[0], (InputSource)actual[0]), (boolean)true);
            }
            catch (Throwable ex) {
                System.out.println("Control:");
                this.dumpInputSource(control[1]);
                System.out.println("Actual:");
                this.dumpInputSource(actual[1]);
                throw ex;
            }
            if (this.serializationMethod.isCaching()) {
                TestSerialize.assertTrue((boolean)container.isComplete());
            } else {
                TestSerialize.assertFalse((boolean)container.isComplete());
            }
        }
        finally {
            builder.close();
        }
    }

    private InputSource[] duplicateInputSource(InputSource is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is.getByteStream(), (OutputStream)baos);
        byte[] content = baos.toByteArray();
        return new InputSource[]{new InputSource(new ByteArrayInputStream(content)), new InputSource(new ByteArrayInputStream(content))};
    }

    private void dumpInputSource(InputSource is) throws IOException {
        IOUtils.copy((InputStream)is.getByteStream(), (OutputStream)System.out);
        System.out.println();
    }
}

